/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.constraints;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.StateMachine;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.core.Activator;

public class StateMachineLocationChecker
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        IStatus success = ctx.createSuccessStatus();
        Boolean checkStateMachines = Activator.getDefault().getPreferenceStore().getBoolean("StateMachine");
        if (checkStateMachines.booleanValue()) {
            StateMachine sm = (StateMachine)ctx.getTarget();
            if (!ctx.getEventType().equals(EMFEventType.SET)) {
                return success;
            }
            if (!(sm.getOwner() instanceof Class)) {
                IStatus failure = this.createFailureStatus(ctx, null, sm);
                return failure;
            }
            List subComponents = EntityUtil.getInstance().getSubComponentsInstances((Class)sm.getOwner());
            if (!subComponents.isEmpty()) {
                IStatus failure = this.createFailureStatus(ctx, ((Class)sm.getOwner()).getName(), sm);
                return failure;
            }
        }
        return success;
    }

    private IStatus createFailureStatus(IValidationContext ctx, String ownerName, StateMachine sm) {
        return ctx.createFailureStatus(new Object[]{sm.getName(), ownerName == null ? "The state machine must be associated only to the leaf component." : "The state machine must be associated only to the leaf component. '" + ownerName + "' is not a leaf component."});
    }
}

