/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.listeners;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.polarsys.chess.contracts.chessextension.Activator;
import org.polarsys.chess.contracts.chessextension.managers.CHESSContractProfileManager;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;

public class PapyrusModelListener
implements IPapyrusListener {
    private static final String CONTRACT = "CHESSContract::Contract";
    private static final String ASSUME = "Assume";
    private static final String GUARANTEE = "Guarantee";
    private static final Object FEATURE_NAME = "name";

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (Workbench.getInstance() != null && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().isEditorAreaVisible() && notifier instanceof Class) {
            EAttribute attr;
            Class cblock = (Class)notifier;
            if (notification.getEventType() == 31 && cblock.getAppliedStereotype(CONTRACT) != null) {
                IEditorPart editor = null;
                try {
                    editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                }
                catch (Exception exception) {}
                if (editor != null) {
                    Activator plugin = Activator.getDefault();
                    ImageRegistry imageRegistry = plugin.getImageRegistry();
                    Image chessImage = imageRegistry.get("org.polarsys.chess.contracts.chessextension.CHESSicon");
                    MessageDialog md = new MessageDialog(editor.getSite().getShell(), "Create Contract", chessImage, "Do you want to create a contract with predefined empty Assume and Guarantee FormalProperty?", 5, new String[]{"Yes", "No"}, 0);
                    md.setBlockOnOpen(true);
                    int res = md.open();
                    if (res == 0) {
                        Constraint assumeConst = cblock.createOwnedRule(String.valueOf(cblock.getName()) + "_" + ASSUME);
                        Constraint guaranteeConst = cblock.createOwnedRule(String.valueOf(cblock.getName()) + "_" + GUARANTEE);
                        LiteralString assumeValue = UMLFactory.eINSTANCE.createLiteralString();
                        assumeValue.setName(assumeConst.getName());
                        assumeConst.setSpecification((ValueSpecification)assumeValue);
                        LiteralString guaranteeValue = UMLFactory.eINSTANCE.createLiteralString();
                        guaranteeValue.setName(guaranteeConst.getName());
                        guaranteeConst.setSpecification((ValueSpecification)guaranteeValue);
                        try {
                            Stereotype fpStereotype = CHESSContractProfileManager.getFormalProperty(cblock.eResource().getResourceSet());
                            FormalProperty assume = (FormalProperty)assumeConst.applyStereotype(fpStereotype);
                            FormalProperty guarantee = (FormalProperty)guaranteeConst.applyStereotype(fpStereotype);
                            Stereotype contrStereo = cblock.getAppliedStereotype(CONTRACT);
                            cblock.setValue(contrStereo, ASSUME, (Object)assume);
                            cblock.setValue(contrStereo, GUARANTEE, (Object)guarantee);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (notification.getEventType() == 1 && notification.getFeature() instanceof EAttribute && cblock.getAppliedStereotype(CONTRACT) != null && (attr = (EAttribute)notification.getFeature()).getName().equals(FEATURE_NAME)) {
                EList rules = cblock.getOwnedRules();
                for (Constraint constraint : rules) {
                    if (constraint.getName().contains(ASSUME)) {
                        constraint.setName(String.valueOf(notification.getNewStringValue()) + "_" + ASSUME);
                    }
                    if (constraint.getName().contains(GUARANTEE)) {
                        constraint.setName(String.valueOf(notification.getNewStringValue()) + "_" + GUARANTEE);
                    }
                    constraint.getSpecification().setName(constraint.getName());
                }
            }
        }
    }
}

