/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.model;

import java.util.Arrays;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Parameter;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.multicore.utils.QueryUtils;

public final class CHTask {
    private CHRtPortSlot slot;
    private CHRtSpecification spec;

    public CHTask(CHRtPortSlot slot, CHRtSpecification spec) {
        this.slot = slot;
        this.spec = spec;
    }

    public CHRtPortSlot getSlot() {
        return this.slot;
    }

    public CHRtSpecification getCHRtSpecification() {
        return this.spec;
    }

    public String toString() {
        return String.valueOf(this.slot.getBase_Slot().getOwningInstance().getName()) + "_" + this.slot.getBase_Slot().getDefiningFeature().getName() + "_" + this.spec.getContext().getName() + "(" + this.getType() + ")";
    }

    public String getName() {
        return String.valueOf(this.slot.getBase_Slot().getOwningInstance().getName()) + "_" + this.slot.getBase_Slot().getDefiningFeature().getName() + "_" + this.getOpName(this.spec.getContext()) + "_task";
    }

    private String getOpName(BehavioralFeature op) {
        StringBuilder sb = new StringBuilder(op.getName());
        for (Parameter par : op.getOwnedParameters()) {
            sb.append('_').append(par.getType().getName());
        }
        return sb.toString();
    }

    public String getType() {
        String type = "simple_operation";
        if (QueryUtils.isOccKindSporadicOrPeriodic(this.spec.getOccKind())) {
            type = "task";
        } else if (QueryUtils.isGuarded(this.spec)) {
            type = "shared_resource";
        }
        return type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CHTask)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CHTask that = (CHTask)obj;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.slot.getBase_Slot().getOwningInstance().getName(), this.slot.getBase_Slot().getDefiningFeature().getName(), this.spec.getContext().getName()});
    }
}

