/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.tabbedproperties.sections;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.MARTE.MARTE_AnalysisModel.SAM.SaEndtoEndFlow;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.chessmlprofile.Core.PSMPackage;
import org.polarsys.chess.core.util.AnalysisResultData;
import org.polarsys.chess.core.util.EndToEndResultData;
import org.polarsys.chess.core.util.HWAnalysisResultData;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.tabbedproperties.sections.TableCellMouseListener;

public class AnalysisContextProperty
extends AbstractPropertySection {
    private Table swInstanceTable;
    private Table hwTable;
    private Table end2endTable;
    private String[] swInstanceTableTitles = new String[]{"SW instance", "context", "arrivalPattern", "localWCET", "rldl", "priority", "ResponseTime", "blockT", "Sched"};
    private String[] hwTableTitles = new String[]{"HW instance", "Utilisation", "Res"};
    private String[] end2endTableTitles = new String[]{"Scenario", "Deadline", "Res"};
    private ControlAdapter resizeListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            int d = 10;
            int x = ((AnalysisContextProperty)AnalysisContextProperty.this).swInstanceTable.getSize().x - d;
            int width = x / AnalysisContextProperty.this.swInstanceTableTitles.length - AnalysisContextProperty.this.swInstanceTableTitles.length;
            TableColumn[] columns = AnalysisContextProperty.this.swInstanceTable.getColumns();
            int i = 0;
            while (i < columns.length) {
                TableColumn tc = columns[i];
                tc.setWidth(width);
                ++i;
            }
        }
    };

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject eobj;
        TreeSelection treeSelection;
        Object obj;
        super.setInput(part, selection);
        this.cleanPropertyTab();
        this.cleanHWPropertyTab();
        this.cleanEndtoEndPropertyTab();
        if (selection instanceof TreeSelection && (obj = (treeSelection = (TreeSelection)selection).getFirstElement()) instanceof EObjectTreeElement && (eobj = ((EObjectTreeElement)obj).getEObject()) instanceof Class && ((Class)eobj).getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") != null) {
            List listData = UMLUtils.getAnalysisResults((Class)((Class)eobj));
            this.initTableFromResultData(listData);
            List listHWData = UMLUtils.getHWAnalysisResults((Class)((Class)eobj));
            this.initHWTableFromResultData(listHWData);
            List listEndtoEndData = UMLUtils.getEndtoEndAnalysisResults((Class)((Class)eobj));
            this.initEndtoEndTableFromResultData(listEndtoEndData);
        }
    }

    private void cleanPropertyTab() {
        this.swInstanceTable.removeAll();
    }

    private void cleanHWPropertyTab() {
        this.hwTable.removeAll();
    }

    private void cleanEndtoEndPropertyTab() {
        this.end2endTable.removeAll();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TableColumn column;
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite container = this.getWidgetFactory().createComposite(parent, 0);
        GridLayout gridLayout = new GridLayout(8, true);
        container.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, false, false);
        this.swInstanceTable = new Table(container, 2816);
        this.swInstanceTable.setLinesVisible(true);
        this.swInstanceTable.setHeaderVisible(true);
        this.swInstanceTable.addControlListener((ControlListener)this.resizeListener);
        data = new GridData(4, 4, true, true, 8, 8);
        this.swInstanceTable.setLayoutData((Object)data);
        int i = 0;
        while (i < this.swInstanceTableTitles.length) {
            column = new TableColumn(this.swInstanceTable, 0);
            column.setText(this.swInstanceTableTitles[i]);
            ++i;
        }
        i = 0;
        while (i < this.swInstanceTableTitles.length) {
            this.swInstanceTable.getColumn(i).pack();
            ++i;
        }
        this.swInstanceTable.addMouseListener((MouseListener)new TableCellMouseListener(this.swInstanceTable));
        this.hwTable = new Table(container, 2816);
        this.hwTable.setLinesVisible(true);
        this.hwTable.setHeaderVisible(true);
        this.hwTable.addControlListener((ControlListener)this.resizeListener);
        data = new GridData(4, 4, true, true, 8, 8);
        this.hwTable.setLayoutData((Object)data);
        i = 0;
        while (i < this.hwTableTitles.length) {
            column = new TableColumn(this.hwTable, 0);
            column.setText(this.hwTableTitles[i]);
            ++i;
        }
        i = 0;
        while (i < this.hwTableTitles.length) {
            this.hwTable.getColumn(i).pack();
            ++i;
        }
        this.end2endTable = new Table(container, 2816);
        this.end2endTable.setLinesVisible(true);
        this.end2endTable.setHeaderVisible(true);
        this.end2endTable.addControlListener((ControlListener)this.resizeListener);
        data = new GridData(4, 4, true, true, 8, 8);
        this.end2endTable.setLayoutData((Object)data);
        i = 0;
        while (i < this.end2endTableTitles.length) {
            column = new TableColumn(this.end2endTable, 0);
            column.setText(this.end2endTableTitles[i]);
            ++i;
        }
        i = 0;
        while (i < this.end2endTableTitles.length) {
            this.end2endTable.getColumn(i).pack();
            ++i;
        }
    }

    public List<EndToEndResultData> OLDgetEndtoEndAnalysisResults(Class contextClass) {
        ArrayList<EndToEndResultData> listData = new ArrayList<EndToEndResultData>();
        Model model = contextClass.getModel();
        Package psm = ViewUtils.getCHESSPSMPackage((Model)model);
        if (contextClass.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaAnalysisContext") == null) {
            return listData;
        }
        String saAnalysisName = contextClass.getQualifiedName();
        for (Package pkg : psm.getNestedPackages()) {
            PSMPackage psmPkg;
            Stereotype stereo = pkg.getAppliedStereotype("CHESS::Core::PSMPackage");
            if (stereo == null || !(psmPkg = (PSMPackage)pkg.getStereotypeApplication(stereo)).getAnalysisContext().getBase_NamedElement().getQualifiedName().equals(saAnalysisName)) continue;
            Package psmPackage = pkg;
            Package psmAnalysisContextPack = (Package)psmPackage.getOwnedMember("AnalysisContext");
            Class psmAnalysisContextClass = null;
            for (Element temp : psmAnalysisContextPack.getOwnedElements()) {
                if (!(temp instanceof Class)) continue;
                psmAnalysisContextClass = (Class)temp;
                for (Element elem : psmAnalysisContextClass.allOwnedElements()) {
                    if (!(elem instanceof Activity)) continue;
                    Activity activity = (Activity)elem;
                    if (elem.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow") == null) continue;
                    SaEndtoEndFlow pimEndtoEndFlow = null;
                    for (Constraint constr : psmAnalysisContextClass.getOwnedRules()) {
                        if (!constr.getConstrainedElements().contains((Object)activity)) continue;
                        for (Element constrained : constr.getConstrainedElements()) {
                            if (!(constrained instanceof Activity) || constrained == activity || constrained.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow") == null || constrained.getAppliedStereotype("MARTE::MARTE_AnalysisModel::GQAM::GaWorkloadBehavior") == null) continue;
                            pimEndtoEndFlow = (SaEndtoEndFlow)constrained.getStereotypeApplication(constrained.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow"));
                            break;
                        }
                        if (pimEndtoEndFlow != null) break;
                    }
                    if (pimEndtoEndFlow == null) continue;
                    SaEndtoEndFlow psmEndtoEndFlow = (SaEndtoEndFlow)activity.getStereotypeApplication(activity.getAppliedStereotype("MARTE::MARTE_AnalysisModel::SAM::SaEndtoEndFlow"));
                    EndToEndResultData data = new EndToEndResultData();
                    data.scenarioName = activity.getName();
                    data.deadline = (String)pimEndtoEndFlow.getEnd2EndD().get(0);
                    data.respTime = (String)psmEndtoEndFlow.getEnd2EndT().get(0);
                    listData.add(data);
                }
            }
        }
        return listData;
    }

    private void initTableFromResultData(List<AnalysisResultData> resultDataList) {
        this.cleanPropertyTab();
        for (AnalysisResultData res : resultDataList) {
            TableItem item = new TableItem(this.swInstanceTable, 0);
            AbstractMap.SimpleEntry<InstanceSpecification, Operation> data = new AbstractMap.SimpleEntry<InstanceSpecification, Operation>(res.instSpec, res.ctxOP);
            item.setData(data);
            item.setText(0, res.instance);
            item.setText(1, res.context);
            item.setText(2, res.arrival);
            item.setText(3, res.localWCET);
            item.setText(4, res.rldl);
            item.setText(5, res.priority);
            item.setText(6, res.respT);
            item.setText(7, res.blockT);
            item.setText(8, res.isSched);
        }
    }

    private void initHWTableFromResultData(List<HWAnalysisResultData> resultDataList) {
        this.cleanHWPropertyTab();
        for (HWAnalysisResultData res : resultDataList) {
            TableItem item = new TableItem(this.hwTable, 0);
            item.setText(0, res.hw_instance);
            item.setText(1, res.hw_utilization);
            item.setText(2, res.hw_res);
        }
    }

    private void initEndtoEndTableFromResultData(List<EndToEndResultData> resultDataList) {
        this.cleanEndtoEndPropertyTab();
        for (EndToEndResultData res : resultDataList) {
            TableItem item = new TableItem(this.end2endTable, 0);
            item.setText(0, res.scenarioName);
            item.setText(1, res.deadline);
            item.setText(2, res.respTime);
        }
    }
}

