/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.CharShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharShortMap;
import org.eclipse.collections.api.map.primitive.MutableCharShortMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.CharShortPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedCharShortProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.map.mutable.primitive.CharShortHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharShortHashMap
implements ImmutableCharShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharShortMap delegate;

    ImmutableCharShortHashMap(CharShortMap delegate) {
        this.delegate = new CharShortHashMap(delegate);
    }

    public short get(char key) {
        return this.delegate.get(key);
    }

    public short getIfAbsent(char key, short ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public short getOrThrow(char key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(short value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(CharShortProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<CharShortPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableCharShortMap select(CharShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharShortMap reject(CharShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableCharShortMap toImmutable() {
        return this;
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)this.delegate.shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableShortCollection select(ShortPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public short max() {
        return this.delegate.max();
    }

    public short maxIfEmpty(short defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public short min() {
        return this.delegate.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public short[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableShortList toSortedList() {
        return this.delegate.toSortedList();
    }

    public short[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(short value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableShortList toList() {
        return this.delegate.toList();
    }

    public MutableShortSet toSet() {
        return this.delegate.toSet();
    }

    public MutableShortBag toBag() {
        return this.delegate.toBag();
    }

    public LazyShortIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableCharShortMap newWithKeyValue(char key, short value) {
        CharShortHashMap map = new CharShortHashMap(this.size() + 1);
        map.putAll((CharShortMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableCharShortMap newWithoutKey(char key) {
        CharShortHashMap map = new CharShortHashMap(this.size());
        map.putAll((CharShortMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableCharShortMap newWithoutAllKeys(CharIterable keys) {
        CharShortHashMap map = new CharShortHashMap(this.size());
        map.putAll((CharShortMap)this);
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(this.delegate.keySet());
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableCharShortMapSerializationProxy((CharShortMap)this);
    }

    protected static class ImmutableCharShortMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private CharShortMap map;

        public ImmutableCharShortMapSerializationProxy() {
        }

        protected ImmutableCharShortMapSerializationProxy(CharShortMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((CharShortProcedure)new CheckedCharShortProcedure(){

                    public void safeValue(char key, short value) throws IOException {
                        out.writeChar(key);
                        out.writeShort(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            CharShortHashMap deserializedMap = new CharShortHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readChar(), in.readShort());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

