/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.pde.internal.junit.runtime.MultiBundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class RemotePluginTestRunner
extends RemoteTestRunner {
    private String fTestPluginName;
    private ClassLoader fLoaderClassLoader;

    public static void main(String[] args) {
        RemotePluginTestRunner testRunner = new RemotePluginTestRunner();
        testRunner.init(args);
        ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
        if (RemotePluginTestRunner.isJUnit5(args)) {
            Thread.currentThread().setContextClassLoader(RemotePluginTestRunner.createJUnit5PluginClassLoader(testRunner.getTestPluginName()));
        }
        testRunner.run();
        if (RemotePluginTestRunner.isJUnit5(args)) {
            Thread.currentThread().setContextClassLoader(currentTCCL);
        }
    }

    private static ClassLoader createJUnit5PluginClassLoader(String testPluginName) {
        Bundle testBundle = Platform.getBundle((String)testPluginName);
        if (testBundle == null) {
            throw new IllegalArgumentException("Bundle \"" + testPluginName + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        List<Bundle> platformEngineBundles = RemotePluginTestRunner.findTestEngineBundles();
        platformEngineBundles.add(testBundle);
        return new MultiBundleClassLoader(platformEngineBundles);
    }

    private static List<Bundle> findTestEngineBundles() {
        BundleContext bundleContext = FrameworkUtil.getBundle(RemotePluginTestRunner.class).getBundleContext();
        ArrayList<Bundle> engineBundles = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            try {
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                Collection listResources = bundleWiring.listResources("META-INF/services", "org.junit.platform.engine.TestEngine", 2);
                if (!listResources.isEmpty()) {
                    engineBundles.add(bundle);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return engineBundles;
    }

    protected ClassLoader getTestClassLoader() {
        String pluginId = this.getTestPluginName();
        return this.getClassLoader(pluginId);
    }

    public ClassLoader getClassLoader(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + bundleId + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        return new BundleClassLoader(bundle);
    }

    public void init(String[] args) {
        this.readPluginArgs(args);
        boolean isJUnit5 = RemotePluginTestRunner.isJUnit5(args);
        if (isJUnit5) {
            ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(new MultiBundleClassLoader(RemotePluginTestRunner.findTestEngineBundles()));
                this.defaultInit(args);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentTCCL);
            }
            return;
        }
        this.defaultInit(args);
    }

    private static boolean runAsJUnit5(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.equalsIgnoreCase("-runasjunit5")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isJUnit5(String[] args) {
        if (RemotePluginTestRunner.runAsJUnit5(args)) {
            return true;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("org.eclipse.jdt.internal.junit5.runner.JUnit5TestLoader")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void readPluginArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (this.isFlag(args, i, "-testpluginname")) {
                this.setTestPluginName(args[i + 1]);
            }
            if (this.isFlag(args, i, "-loaderpluginname")) {
                this.fLoaderClassLoader = this.getClassLoader(args[i + 1]);
            }
            ++i;
        }
        if (this.getTestPluginName() == null) {
            throw new IllegalArgumentException("Parameter -testpluginnname not specified.");
        }
        if (this.fLoaderClassLoader == null) {
            this.fLoaderClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    protected Class<?> loadTestLoaderClass(String className) throws ClassNotFoundException {
        return this.fLoaderClassLoader.loadClass(className);
    }

    private boolean isFlag(String[] args, int i, String wantedFlag) {
        String lowerCase = args[i].toLowerCase(Locale.ENGLISH);
        return lowerCase.equals(wantedFlag) && i < args.length - 1;
    }

    public String getTestPluginName() {
        return this.fTestPluginName;
    }

    public void setTestPluginName(String fTestPluginName) {
        this.fTestPluginName = fTestPluginName;
    }

    static class BundleClassLoader
    extends ClassLoader {
        private Bundle bundle;

        public BundleClassLoader(Bundle target) {
            this.bundle = target;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }
    }
}

