/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.control.impl.TerminalPlugin;
import org.eclipse.tm.internal.terminal.textcanvas.ILinelRenderer;
import org.eclipse.tm.internal.terminal.textcanvas.ITextCanvasModel;
import org.eclipse.tm.internal.terminal.textcanvas.StyleMap;
import org.eclipse.tm.internal.terminal.textcanvas.TextCanvas;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.TerminalColor;
import org.eclipse.tm.terminal.model.TerminalStyle;

public class TextLineRenderer
implements ILinelRenderer {
    private static final boolean DEBUG_HOVER = TerminalPlugin.isOptionEnabled("org.eclipse.tm.terminal.control/debug/log/hover");
    private final ITextCanvasModel fModel;
    private final StyleMap fStyleMap;

    public TextLineRenderer(TextCanvas c, ITextCanvasModel model) {
        this.fModel = model;
        this.fStyleMap = new StyleMap();
    }

    @Override
    public int getCellWidth() {
        return this.fStyleMap.getFontWidth();
    }

    @Override
    public int getCellHeight() {
        return this.fStyleMap.getFontHeight();
    }

    @Override
    public void drawLine(ITextCanvasModel model, GC gc, int line, int x, int y, int colFirst, int colLast) {
        int width = this.getCellWidth() * (colLast - colFirst);
        int height = this.getCellHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        Image buffer = new Image(gc.getDevice(), width, height);
        GC doubleBufferGC = new GC((Drawable)buffer);
        if (line < 0 || line >= this.getTerminalText().getHeight() || colFirst >= this.getTerminalText().getWidth() || colFirst - colLast == 0) {
            this.fillBackground(doubleBufferGC, 0, 0, width, height);
        } else {
            colLast = Math.min(colLast, this.getTerminalText().getWidth());
            LineSegment[] segments = this.getTerminalText().getLineSegments(line, colFirst, colLast - colFirst);
            int i = 0;
            while (i < segments.length) {
                LineSegment segment = segments[i];
                TerminalStyle style = segment.getStyle();
                this.setupGC(doubleBufferGC, style);
                String text = segment.getText();
                this.drawText(doubleBufferGC, 0, 0, colFirst, segment.getColumn(), text);
                this.drawCursor(model, doubleBufferGC, line, 0, 0, colFirst);
                ++i;
            }
            if (this.fModel.hasHoverSelection(line)) {
                int colEnd;
                if (DEBUG_HOVER) {
                    System.out.format("hover: %s  contains hover selection\n", line);
                }
                Point hsStart = this.fModel.getHoverSelectionStart();
                Point hsEnd = this.fModel.getHoverSelectionEnd();
                int colStart = line == hsStart.y ? hsStart.x : 0;
                int n = colEnd = line == hsEnd.y ? hsEnd.x : this.getTerminalText().getWidth();
                if (colStart < colEnd) {
                    RGB defaultFg = this.fStyleMap.getForegrondRGB(null);
                    doubleBufferGC.setForeground(new Color(doubleBufferGC.getDevice(), defaultFg));
                    this.drawUnderline(doubleBufferGC, colStart, colEnd);
                }
            }
            if (this.fModel.hasLineSelection(line)) {
                TerminalStyle style = TerminalStyle.getStyle(TerminalColor.SELECTION_FOREGROUND, TerminalColor.SELECTION_BACKGROUND);
                this.setupGC(doubleBufferGC, style);
                Point start = model.getSelectionStart();
                Point end = model.getSelectionEnd();
                char[] chars = model.getTerminalText().getChars(line);
                if (chars != null) {
                    int offset = 0;
                    if (start.y == line) {
                        offset = start.x;
                    }
                    offset = Math.max(offset, colFirst);
                    int len = end.y == line ? end.x - offset + 1 : chars.length - offset + 1;
                    if ((len = Math.min(len, chars.length - offset)) > 0) {
                        String text = new String(chars, offset, len);
                        this.drawText(doubleBufferGC, 0, 0, colFirst, offset, text);
                    }
                }
            }
        }
        gc.drawImage(buffer, x, y);
        doubleBufferGC.dispose();
        buffer.dispose();
    }

    private void fillBackground(GC gc, int x, int y, int width, int height) {
        Color bg = gc.getBackground();
        gc.setBackground(this.getDefaultBackgroundColor(gc.getDevice()));
        gc.fillRectangle(x, y, width, height);
        gc.setBackground(bg);
    }

    @Override
    public Color getDefaultBackgroundColor() {
        return this.getDefaultBackgroundColor((Device)Display.getDefault());
    }

    @Override
    public Color getDefaultBackgroundColor(Device device) {
        RGB backgroundRGB = this.fStyleMap.getBackgroundRGB(null);
        return new Color(device, backgroundRGB);
    }

    private void drawCursor(ITextCanvasModel model, GC gc, int row, int x, int y, int colFirst) {
        int cursorColumn;
        if (!model.isCursorOn()) {
            return;
        }
        int cursorLine = model.getCursorLine();
        if (row == cursorLine && (cursorColumn = model.getCursorColumn()) < this.getTerminalText().getWidth()) {
            TerminalStyle style = this.getTerminalText().getStyle(row, cursorColumn);
            if (style == null) {
                style = TerminalStyle.getStyle(TerminalColor.FOREGROUND, TerminalColor.BACKGROUND);
            }
            style = style.setReverse(!style.isReverse());
            this.setupGC(gc, style);
            String text = String.valueOf(this.getTerminalText().getChar(row, cursorColumn));
            this.drawText(gc, x, y, colFirst, cursorColumn, text);
        }
    }

    private void drawText(GC gc, int x, int y, int colFirst, int col, String text) {
        int offset = (col - colFirst) * this.getCellWidth();
        if (this.fStyleMap.isFontProportional()) {
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                int xx = x + offset + i * this.fStyleMap.getFontWidth();
                gc.fillRectangle(xx, y, this.fStyleMap.getFontWidth(), this.fStyleMap.getFontHeight());
                if (c != ' ' && c != '\u0000') {
                    gc.drawString(String.valueOf(c), this.fStyleMap.getCharOffset(c) + xx, y, false);
                }
                ++i;
            }
        } else {
            text = text.replace('\u0000', ' ');
            gc.drawString(text, x + offset, y, false);
        }
    }

    private void drawUnderline(GC gc, int colStart, int colEnd) {
        int y = this.getCellHeight() - 1;
        int x = this.getCellWidth() * colStart;
        int x2 = (colEnd + 1) * this.getCellWidth() - 1;
        gc.drawLine(x, y, x2, y);
    }

    private void setupGC(GC gc, TerminalStyle style) {
        RGB foregrondColor = this.fStyleMap.getForegrondRGB(style);
        gc.setForeground(new Color(gc.getDevice(), foregrondColor));
        RGB backgroundColor = this.fStyleMap.getBackgroundRGB(style);
        gc.setBackground(new Color(gc.getDevice(), backgroundColor));
        Font f = this.fStyleMap.getFont(style);
        if (f != gc.getFont()) {
            gc.setFont(f);
        }
    }

    ITerminalTextDataReadOnly getTerminalText() {
        return this.fModel.getTerminalText();
    }

    @Override
    @Deprecated
    public void onFontChange() {
        this.fStyleMap.updateFont();
    }

    @Override
    public void updateFont(String fontName) {
        this.fStyleMap.updateFont(fontName);
    }

    @Override
    public void updateColors(Map<TerminalColor, RGB> map) {
        this.fStyleMap.updateColors(map);
    }

    @Override
    public void setInvertedColors(boolean invert) {
        this.fStyleMap.setInvertedColors(invert);
    }

    @Override
    public boolean isInvertedColors() {
        return this.fStyleMap.isInvertedColors();
    }
}

