/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.columns;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABasePrimaryKey;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseUniqueConstraint;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseasabasesqlmodelFactory;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.ICuttablePart;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.IValidatablePart;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.commonui.ColumnDefaultValueInputDialog;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.columns.ASATableEditorColumnRowData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.columns.ASATableEditorColumnsLabelProvider;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.columns.ASATableEditorColumnsTableData;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.pages.columns.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils.ConstraintCreationUtils;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.utils.SybComponentsImages;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.common.core.tableviewer.AbstractTableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.RowData;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.CopyRowAction;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.CutRowAction;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.ObjectTransfer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.PasteRowAction;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.PasteRowActionUtil;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.RemoveRowAction;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableCellEditor;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableCheckBoxCellEditor;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableComboBoxCellEditor;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDataContentProvider;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDataLabelProvider;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDialogCellEditor;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectImmutableModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.SchemaObjectEditorModelListenersNotifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ASATableEditorColumnsViewer {
    protected AccessibleTableViewer _viewer;
    protected AbstractTableData _data;
    protected ICellModifier _modifier;
    protected DatabaseDefinition _databaseDefinition;
    protected SchemaObjectEditorModelListenersNotifier _notifier;
    protected Schema _schema;
    protected Diagnostic _diagnostic;
    protected boolean _needUniqueColumn = true;
    protected boolean _needMarkerColumn = false;
    protected FormToolkit _toolkit;
    public static final String COPY_ROW_ACTION_EFINITION_ID = "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableschemaeditor.copycolumn";
    public static final String PASTE_ROW_ACTION_DEFINITION_ID = "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableschemaeditor.pastecolumn";
    public static final String CUT_ROW_ACTION_DEFINITION_ID = "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableschemaeditor.cutcolumn";
    private CutRowAction _cutRowAction;
    private CopyRowAction _copyRowAction;
    private PasteRowAction _pasteRowAction;
    private RemoveRowAction _removeRowAction;
    private ColumnRowAddAction _addRowAction;
    private MenuManager _menuManager;
    private Clipboard _clipboard;
    private static final String EDIT_GROUP = "edit";
    private static final String DEL_GROUP = "delete";
    protected IValidatablePart _validatablePart;
    protected ICuttablePart _cuttablePart;
    protected IEditorPart _editor;
    protected DatabaseIdentifier _databaseIdentifier;

    private void createActions() {
        this._clipboard = new Clipboard(this._viewer.getControl().getDisplay());
        this._cutRowAction = new ColumnRowCutAction(this._viewer, this._clipboard);
        this._copyRowAction = new CopyRowAction(this._viewer, this._clipboard);
        this._copyRowAction.setText(Messages.ASATableEditorColumnsViewer_copy);
        this._pasteRowAction = new ColumnRowPasteAction(this._viewer, this._clipboard);
        this._removeRowAction = new ColumnnRowRemoveAction(this._viewer);
        this._addRowAction = new ColumnRowAddAction(this._viewer);
        this._cutRowAction.setActionDefinitionId(CUT_ROW_ACTION_DEFINITION_ID);
        this._copyRowAction.setActionDefinitionId(COPY_ROW_ACTION_EFINITION_ID);
        this._pasteRowAction.setActionDefinitionId(PASTE_ROW_ACTION_DEFINITION_ID);
        if (this._editor != null) {
            IKeyBindingService keyBinding = this._editor.getEditorSite().getKeyBindingService();
            IActionBars bars = this._editor.getEditorSite().getActionBars();
            bars.setGlobalActionHandler(CUT_ROW_ACTION_DEFINITION_ID, (IAction)this._cutRowAction);
            keyBinding.registerAction((IAction)this._cutRowAction);
            bars.setGlobalActionHandler(COPY_ROW_ACTION_EFINITION_ID, (IAction)this._copyRowAction);
            keyBinding.registerAction((IAction)this._copyRowAction);
            bars.setGlobalActionHandler(PASTE_ROW_ACTION_DEFINITION_ID, (IAction)this._pasteRowAction);
            keyBinding.registerAction((IAction)this._pasteRowAction);
            bars.updateActionBars();
        }
    }

    private void createContextMenu() {
        this.createActions();
        this._menuManager = new MenuManager();
        this._menuManager.setRemoveAllWhenShown(true);
        this._menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator(ASATableEditorColumnsViewer.DEL_GROUP));
                manager.appendToGroup(ASATableEditorColumnsViewer.DEL_GROUP, (IAction)ASATableEditorColumnsViewer.this._addRowAction);
                manager.appendToGroup(ASATableEditorColumnsViewer.DEL_GROUP, (IAction)ASATableEditorColumnsViewer.this._removeRowAction);
                manager.add((IContributionItem)new Separator(ASATableEditorColumnsViewer.EDIT_GROUP));
                manager.appendToGroup(ASATableEditorColumnsViewer.EDIT_GROUP, (IAction)ASATableEditorColumnsViewer.this._cutRowAction);
                manager.appendToGroup(ASATableEditorColumnsViewer.EDIT_GROUP, (IAction)ASATableEditorColumnsViewer.this._copyRowAction);
                manager.appendToGroup(ASATableEditorColumnsViewer.EDIT_GROUP, (IAction)ASATableEditorColumnsViewer.this._pasteRowAction);
                ASATableEditorColumnsViewer.this._pasteRowAction.updateEnablement();
            }
        });
        Menu menu = this._menuManager.createContextMenu((Control)this._viewer.getTable());
        this._viewer.getTable().setMenu(menu);
        this._viewer.getCursor().setMenu(menu);
    }

    public ASATableEditorColumnsViewer(ICellModifier modifier, DatabaseDefinition dbdefinition, AbstractTableData data, Schema schema, boolean needUniqueColumn, boolean needMarkerColumn, SchemaObjectEditorModelListenersNotifier notifier, FormToolkit toolkit, IValidatablePart part, ICuttablePart cuttablePart, IEditorPart editor, DatabaseIdentifier databaseIdentifier) {
        this._modifier = modifier;
        this._databaseDefinition = dbdefinition;
        this._data = data;
        this._schema = schema;
        this._needUniqueColumn = needUniqueColumn;
        this._needMarkerColumn = needMarkerColumn;
        this._notifier = notifier;
        this._toolkit = toolkit;
        this._validatablePart = part;
        this._cuttablePart = cuttablePart;
        this._editor = editor;
        this._databaseIdentifier = databaseIdentifier;
    }

    public void createTable(Composite parent) {
        org.eclipse.swt.widgets.Table table = null;
        if (this._toolkit != null) {
            table = this._toolkit.createTable(parent, 768);
            this._toolkit.paintBordersFor(parent);
        } else {
            table = new org.eclipse.swt.widgets.Table(parent, 2816);
        }
        this._viewer = new AccessibleTableViewer(table);
        this.createContextMenu();
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        this._viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this._viewer.setContentProvider((IContentProvider)new TableDataContentProvider());
        this.configureTable();
        this._viewer.setInput((Object)this._data);
        this._viewer.getTable().setSelection(0);
        this._viewer.getCursor().setSelection(0, 3);
    }

    protected Schema getOriginalSchema() {
        ISchemaObjectImmutableModel model = ((ISchemaObjectEditorInput)this._editor.getEditorInput()).getEditModelObject().getSchemaObjectImmutableModel();
        Table t = (Table)model.getMainSQLObject();
        return t.getSchema();
    }

    protected void configureTable() {
        this._viewer.getTable().setHeaderVisible(true);
        this._viewer.getTable().setLinesVisible(true);
        this._viewer.getTable().setLayoutData((Object)new GridData(1808));
        CellEditor[] editors = new CellEditor[this._data.getColumnCount()];
        String[] properties = new String[this._data.getColumnCount()];
        int i = 0;
        while (i < this._data.getColumnCount()) {
            TableColumn col = new TableColumn(this._viewer.getTable(), 0);
            col.setText(this._data.getColumnName(i));
            col.pack();
            col.setWidth(ASATableEditorColumnsTableData.COLUMN_LENGTH[i]);
            if (i == 0) {
                col.setResizable(false);
            }
            if (!this._needMarkerColumn && i == 0) {
                col.setResizable(false);
                col.setWidth(0);
                col.setText("");
            }
            if (!this._needUniqueColumn && i == 6) {
                col.setResizable(false);
                col.setWidth(0);
                col.setText("");
            }
            Object currentEditor = null;
            switch (i) {
                case 1: {
                    currentEditor = new TableCheckBoxCellEditor(this._viewer);
                    break;
                }
                case 2: {
                    currentEditor = new TableCellEditor(this._viewer);
                    break;
                }
                case 3: {
                    SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)ProfileUtil.getDatabaseVendorDefinitionId((String)this._databaseIdentifier.getProfileName()));
                    DataTypeProvider provider = config.getSQLDataService().getDataTypeProvider();
                    currentEditor = new TableComboBoxCellEditor(this._viewer, provider.getAvailableDataTypesDisplayString(3, this.getOriginalSchema(), this._databaseIdentifier));
                    break;
                }
                case 4: {
                    currentEditor = new TableCheckBoxCellEditor(this._viewer);
                    break;
                }
                case 5: {
                    currentEditor = new TableDialogCellEditor(this._viewer){

                        public Object openDialogBox(Control cellEditorWindow) {
                            ColumnDefaultValueInputDialog dlg;
                            if (ASATableEditorColumnsViewer.this._viewer.getRow() == null) {
                                return null;
                            }
                            ASATableEditorColumnRowData row = (ASATableEditorColumnRowData)ASATableEditorColumnsViewer.this._viewer.getRow();
                            SybaseASABaseColumn column = ((ASATableEditorColumnRowData)ASATableEditorColumnsViewer.this._viewer.getRow()).getColumn();
                            if (column.getDataType() == null) {
                                String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                                MessageDialog d = new MessageDialog(ExamplePlugin.getActiveWorkbenchShell(), Messages.ASATableEditorColumnsViewer_warning, null, Messages.ASATableEditorColumnsViewer_invalid_data_type, 4, buttons, 0);
                                d.open();
                                return null;
                            }
                            Shell shell = cellEditorWindow.getShell();
                            if (!column.isIsComputedColumn()) {
                                // empty if block
                            }
                            if ((dlg = new ColumnDefaultValueInputDialog(shell, column, false)).open() == 0) {
                                row.updateValue(5, column.getDefaultValue());
                                ASATableEditorColumnsViewer.this._viewer.refresh();
                                ASATableEditorColumnsViewer.this._viewer.getCursor().edit();
                            }
                            return null;
                        }
                    };
                    break;
                }
                case 6: {
                    if (!this._needUniqueColumn) break;
                    currentEditor = new TableCheckBoxCellEditor(this._viewer);
                    break;
                }
                case 7: {
                    currentEditor = new TableCellEditor(this._viewer);
                    break;
                }
            }
            editors[i] = currentEditor;
            properties[i] = this._data.getColumnName(i);
            ++i;
        }
        this._viewer.setColumnProperties(properties);
        this._viewer.setCellEditors(editors);
        this._viewer.setCellModifier(this._modifier);
    }

    public AccessibleTableViewer getViewer() {
        return this._viewer;
    }

    public void setDataAsInput(AbstractTableData data) {
        if (data != null) {
            this._viewer.setInput((Object)data);
            this._data = data;
        }
    }

    public AbstractTableData getData() {
        return this._data;
    }

    protected SybaseASABaseColumn createColumn() {
        return SybaseasabasesqlmodelFactory.eINSTANCE.createSybaseASABaseColumn();
    }

    public synchronized void populateSQLObject(BaseTable table) {
        this._diagnostic = null;
        Iterator iter = this._data.getRows().iterator();
        if (this._needUniqueColumn) {
            ArrayList<SybaseASABaseUniqueConstraint> uniquesTobeRemoved = new ArrayList<SybaseASABaseUniqueConstraint>();
            for (SybaseASABaseUniqueConstraint u : table.getConstraints()) {
                if (!(u instanceof SybaseASABaseUniqueConstraint) || u instanceof SybaseASABasePrimaryKey) continue;
                uniquesTobeRemoved.add(u);
            }
            table.getConstraints().removeAll(uniquesTobeRemoved);
        }
        PrimaryKey pk = null;
        pk = table.getPrimaryKey();
        if (pk == null) {
            pk = SybaseasabasesqlmodelFactory.eINSTANCE.createSybaseASABasePrimaryKey();
            if (this._notifier != null) {
                pk.eAdapters().add((Object)this._notifier);
            }
        }
        while (iter.hasNext()) {
            SybaseASABaseColumn column;
            ASATableEditorColumnRowData row;
            block26: {
                row = (ASATableEditorColumnRowData)((Object)iter.next());
                if (!row.isDrity()) continue;
                column = row.getColumn();
                if (column == null) {
                    column = this.createColumn();
                    if (this._notifier != null) {
                        column.eAdapters().add((Object)this._notifier);
                    }
                    table.getColumns().add((Object)column);
                }
                column.setName((String)row.getValue(2));
                column.setDescription((String)row.getValue(7));
                String typeStr = (String)row.getValue(3);
                String defaultValue = (String)row.getValue(5);
                if (defaultValue != null && defaultValue.length() != 0) {
                    column.setDefaultValue(defaultValue);
                }
                row.setDataTypeString(typeStr);
                try {
                    if (column.getDataType() == null || !column.getDataType().getName().equals(typeStr)) {
                        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)ProfileUtil.getDatabaseVendorDefinitionId((String)this._databaseIdentifier.getProfileName()));
                        String error = config.getSQLDataService().getDataTypeValidator().isValidDataTypeString(typeStr, this.getOriginalSchema(), 3, this._databaseIdentifier);
                        if (error != null) {
                            throw new Exception(error);
                        }
                        DataType dType = config.getSQLDataService().getDataTypeProvider().getDataType(typeStr, this.getOriginalSchema(), 3, this._databaseIdentifier);
                        String oldTypeString = ConstraintCreationUtils.getDataTypeFullFormatString((Column)column);
                        if (dType != null) {
                            DataType oldType = column.getDataType();
                            column.setDataType(dType);
                            String newTypeString = ConstraintCreationUtils.getDataTypeFullFormatString((Column)column);
                            if (oldTypeString.equals(newTypeString)) {
                                column.setDataType(oldType);
                            }
                        } else {
                            column.setDataType(null);
                            if (this._diagnostic == null) {
                                this._diagnostic = new BasicDiagnostic(4, Integer.toString(8), 0, String.valueOf(Messages.ASATableEditorColumnsViewer_invalid_type) + typeStr, new Object[0]);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    column.setDataType(null);
                    if (this._diagnostic != null) break block26;
                    this._diagnostic = new BasicDiagnostic(4, Integer.toString(8), 0, e.getMessage(), new Object[0]);
                }
            }
            boolean nullable = false;
            String nullableStr = (String)row.getValue(4);
            if (nullableStr != null) {
                nullable = Boolean.valueOf(nullableStr);
            }
            column.setNullable(nullable);
            if (Boolean.valueOf((String)row.getValue(1)).booleanValue()) {
                if (!pk.getMembers().contains((Object)column)) {
                    pk.getMembers().add((Object)column);
                }
            } else if (pk != null && pk.getMembers().contains((Object)column)) {
                pk.getMembers().remove((Object)column);
            }
            this.populateAddtionalColumnParts(column, (IRowData)row);
            if (this._needUniqueColumn) {
                boolean unique = false;
                String uniqueStr = (String)row.getValue(6);
                if (uniqueStr != null) {
                    unique = Boolean.valueOf(uniqueStr);
                }
                if (unique) {
                    SybaseASABaseUniqueConstraint uniqueConstraint = SybaseasabasesqlmodelFactory.eINSTANCE.createSybaseASABaseUniqueConstraint();
                    uniqueConstraint.getMembers().add((Object)column);
                    table.getConstraints().add((Object)uniqueConstraint);
                }
            }
            column.setTable((Table)table);
        }
        if (table.getPrimaryKey() == null) {
            table.getConstraints().add((Object)pk);
        }
        if (pk.getMembers().size() == 0 && table.getPrimaryKey() != null) {
            table.getConstraints().remove((Object)table.getPrimaryKey());
        }
    }

    protected void populateAddtionalColumnParts(SybaseASABaseColumn column, IRowData row) {
        SybaseASABaseColumn asaColumn = column;
        ((ASATableEditorColumnRowData)row).setColumn(asaColumn);
        column.setDescription((String)row.getValue(7));
    }

    public Diagnostic getDiagnosticAfterPopulating() {
        return this._diagnostic;
    }

    protected TableDataLabelProvider createLabelProvider() {
        return new ASATableEditorColumnsLabelProvider();
    }

    class ColumnRowAddAction
    extends Action {
        private AccessibleTableViewer _accessibleTableViewer;

        public ColumnRowAddAction(AccessibleTableViewer accessibleTableViewer) {
            this._accessibleTableViewer = accessibleTableViewer;
            this.setText(Messages.ASATableEditorColumnsViewer_add);
            this._accessibleTableViewer = accessibleTableViewer;
            this.setImageDescriptor(SybComponentsImages.DESC_COLUMN_ADD);
            this.setDisabledImageDescriptor(SybComponentsImages.DESC_COLUMN_ADD_DISABLED);
        }

        public void run() {
            ASATableEditorColumnsTableData data = (ASATableEditorColumnsTableData)((Object)this._accessibleTableViewer.getInput());
            data.insertRow();
            this._accessibleTableViewer.refresh();
            int selection = this._accessibleTableViewer.getTable().getItemCount() - 2;
            this._accessibleTableViewer.getCursor().setSelection(selection, 3);
            this._accessibleTableViewer.getCursor().edit();
        }
    }

    class ColumnRowCutAction
    extends CutRowAction {
        AccessibleTableViewer _accViewer;

        public ColumnRowCutAction(AccessibleTableViewer accessibleTableViewer, Clipboard clipboard) {
            super(accessibleTableViewer, clipboard);
            this.setText(Messages.ASATableEditorColumnsViewer_cut);
            this._accViewer = accessibleTableViewer;
        }

        public void run() {
            boolean okToCut;
            int selectionIndex;
            TableItem selectedItem = this._accViewer.getCursor().getRow();
            int n = selectionIndex = selectedItem != null ? this._accViewer.getTable().indexOf(selectedItem) : this._accViewer.getTable().getItemCount() - 3;
            if (selectionIndex > this._accViewer.getTable().getItemCount() - 3) {
                selectionIndex = this._accViewer.getTable().getItemCount() - 3;
            }
            if (!(okToCut = ASATableEditorColumnsViewer.this._cuttablePart.prepareCut())) {
                return;
            }
            super.run();
            this._accViewer.getCursor().setSelection(selectionIndex, 3);
        }
    }

    class ColumnRowPasteAction
    extends PasteRowAction {
        public ColumnRowPasteAction(AccessibleTableViewer accessibleTableViewer, Clipboard clipboard) {
            super(accessibleTableViewer, clipboard);
            this.setText(Messages.ASATableEditorColumnsViewer_paste);
        }

        public void run() {
            if (!((ITableData)this._accessibleTableViewer.getInput()).isNewRowDataAllowed()) {
                return;
            }
            if (this._clipboard == null || !this._accessibleTableViewer.getCursor().getVisible()) {
                return;
            }
            RowData rowData = (RowData)this._clipboard.getContents((Transfer)ObjectTransfer.getInstance());
            ITableData tableData = (ITableData)this._accessibleTableViewer.getInput();
            Object rData = null;
            try {
                rData = rowData.clone();
                PasteRowActionUtil.addPostfix((RowData)((RowData)rData), (int)2, (ITableData)tableData);
                ((RowData)rData).setTableData(tableData);
                ((ASATableEditorColumnRowData)((Object)rData)).setColumn(null);
                ((ASATableEditorColumnRowData)((Object)rData)).markDirty(true);
                ((ASATableEditorColumnRowData)((Object)rData)).setIsNewlyAdded(true);
                this._accessibleTableViewer.getCursor().getRow();
                this._insertIndex = this._accessibleTableViewer.getTable().getItemCount() - 1;
                tableData.insertRow((IRowData)rData, this._insertIndex);
                this._accessibleTableViewer.refresh();
                this._accessibleTableViewer.getCursor().setSelection(this._insertIndex, 3);
            }
            catch (Exception ex) {
                Status warning = new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", 1, Messages.PasteRowAction_can_not_paste_info, (Throwable)ex);
                ErrorDialog.openError((Shell)this._accessibleTableViewer.getControl().getShell(), (String)Messages.PasteRowAction_can_not_paste_title, null, (IStatus)warning);
            }
            ASATableEditorColumnsViewer.this._validatablePart.validatePart(null);
        }
    }

    class ColumnnRowRemoveAction
    extends RemoveRowAction {
        AccessibleTableViewer _accViewer;

        public ColumnnRowRemoveAction(AccessibleTableViewer accessibleTableViewer) {
            super(accessibleTableViewer);
            this._accViewer = accessibleTableViewer;
            this.setText(Messages.ASATableEditorColumnsViewer_delete);
            this.setImageDescriptor(SybComponentsImages.DESC_COLUMN_DELETE);
            this.setDisabledImageDescriptor(SybComponentsImages.DESC_COLUMN_DELETE_DISABLED);
        }

        public void run() {
            boolean okToCut;
            int selectionIndex;
            TableItem selectedItem = this._accViewer.getCursor().getRow();
            int n = selectionIndex = selectedItem != null ? this._accViewer.getTable().indexOf(selectedItem) : this._accViewer.getTable().getItemCount() - 3;
            if (selectionIndex > this._accViewer.getTable().getItemCount() - 3) {
                selectionIndex = this._accViewer.getTable().getItemCount() - 3;
            }
            if (!(okToCut = ASATableEditorColumnsViewer.this._cuttablePart.prepareCut())) {
                return;
            }
            super.run();
            this._accViewer.getCursor().setSelection(selectionIndex, 3);
            ASATableEditorColumnsViewer.this._validatablePart.validatePart(null);
        }
    }
}

