/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader;

import org.eclipse.datatools.examples.podreader.views.PodContentView;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class Perspective implements IPerspectiveFactory {
	
	public static final String PERSPECTIVE_ID = "org.eclipse.datatools.examples.podreader.perspective";
	
	private static String DSE_ID = "org.eclipse.datatools.connectivity.DataSourceExplorerNavigator";
	
	public void createInitialLayout(IPageLayout layout) {
		layout.setEditorAreaVisible(false);
//		layout.addStandaloneView(DSE_ID, false, 
//				                 IPageLayout.LEFT, 0.25f, 
//				                 layout.getEditorArea());
		layout.addView(DSE_ID, IPageLayout.LEFT, 0.25f, 
                      layout.getEditorArea());
		layout.addStandaloneView(PodContentView.VIEW_ID, false, 
				                IPageLayout.RIGHT, 0.75f, 
				                layout.getEditorArea());
	}
}
