/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal;

import java.util.Stack;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.ExclusivePositionUpdater;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class SymbolInserter
implements VerifyKeyListener,
ILinkedModeListener {
    private boolean _closeSingleQuotes = true;
    private boolean _closeDoubleQuotes = true;
    private boolean _closeBrackets = true;
    private final String CATEGORY = this.toString();
    private IPositionUpdater _updater = new ExclusivePositionUpdater(this.CATEGORY);
    private Stack _bracketLevelStack = new Stack();
    private SQLEditor _sqlEditor;

    public SymbolInserter(SQLEditor editor) {
        this._sqlEditor = editor;
    }

    public void setCloseSingleQuotesEnabled(boolean enabled) {
        this._closeSingleQuotes = enabled;
    }

    public void setCloseDoubleQuotesEnabled(boolean enabled) {
        this._closeDoubleQuotes = enabled;
    }

    public void setCloseBracketsEnabled(boolean enabled) {
        this._closeBrackets = enabled;
    }

    private boolean hasIdentifierToTheRight(IDocument document, int offset) {
        try {
            int end = offset;
            IRegion endLine = document.getLineInformationOfOffset(end);
            int maxEnd = endLine.getOffset() + endLine.getLength();
            while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                ++end;
            }
            return end != maxEnd && Character.isJavaIdentifierPart(document.getChar(end));
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    private boolean hasIdentifierToTheLeft(IDocument document, int offset) {
        try {
            int start = offset;
            IRegion startLine = document.getLineInformationOfOffset(start);
            int minStart = startLine.getOffset();
            return start != minStart && Character.isJavaIdentifierPart(document.getChar(start - 1));
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    private boolean hasCharacterToTheRight(IDocument document, int offset, char character) {
        try {
            int end = offset;
            IRegion endLine = document.getLineInformationOfOffset(end);
            int maxEnd = endLine.getOffset() + endLine.getLength();
            while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                ++end;
            }
            return end != maxEnd && document.getChar(end) == character;
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        ISourceViewer sourceviewer = this._sqlEditor.getSV();
        IDocument document = sourceviewer.getDocument();
        Point selection = sourceviewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        switch (event.character) {
            case '(': {
                if (!this._closeBrackets) {
                    return;
                }
                if (this.hasCharacterToTheRight(document, offset + length, '(')) {
                    return;
                }
            }
            case '\'': {
                if (event.character == '\'') {
                    if (!this._closeSingleQuotes) {
                        return;
                    }
                    if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
            }
            case '\"': {
                if (event.character == '\"') {
                    if (!this._closeDoubleQuotes) {
                        return;
                    }
                    if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
                try {
                    ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___sql_partitioning", (int)offset, (boolean)true);
                    if (!"__dftl_partition_content_type".equals(partition.getType()) && partition.getOffset() != offset) {
                        return;
                    }
                    if (!this._sqlEditor.validateEditorInputState()) {
                        return;
                    }
                    char character = event.character;
                    char closingCharacter = SymbolInserter.getPeerCharacter(character);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(character);
                    buffer.append(closingCharacter);
                    document.replace(offset, length, buffer.toString());
                    SymbolLevel level = new SymbolLevel();
                    this._bracketLevelStack.push(level);
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                    LinkedModeModel model = new LinkedModeModel();
                    model.addLinkingListener((ILinkedModeListener)this);
                    model.addGroup(group);
                    model.forceInstall();
                    level._offset = offset;
                    level._length = 2;
                    if (this._bracketLevelStack.size() == 1) {
                        document.addPositionCategory(this.CATEGORY);
                        document.addPositionUpdater(this._updater);
                    }
                    level._firstPosition = new Position(offset, 1);
                    level._secondPosition = new Position(offset + 1, 1);
                    document.addPosition(this.CATEGORY, level._firstPosition);
                    document.addPosition(this.CATEGORY, level._secondPosition);
                    level._uI = new EditorLinkedModeUI(model, (ITextViewer)sourceviewer);
                    level._uI.setSimpleMode(true);
                    level._uI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, SymbolInserter.getEscapeCharacter(closingCharacter), this._bracketLevelStack));
                    level._uI.setExitPosition((ITextViewer)sourceviewer, offset + 2, 0, Integer.MAX_VALUE);
                    level._uI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                    level._uI.enter();
                    IRegion newSelection = level._uI.getSelectedRegion();
                    sourceviewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                    event.doit = false;
                    break;
                }
                catch (BadLocationException badLocationException) {
                    break;
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
        }
    }

    public void left(LinkedModeModel environment, int flags) {
        final SymbolLevel level = (SymbolLevel)this._bracketLevelStack.pop();
        if (flags != 8) {
            return;
        }
        final IDocument document = this._sqlEditor.getSV().getDocument();
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument d, IDocumentListener owner) {
                    if ((level._firstPosition.isDeleted || level._firstPosition.length == 0) && !level._secondPosition.isDeleted && level._secondPosition.offset == level._firstPosition.offset) {
                        try {
                            document.replace(level._secondPosition.offset, level._secondPosition.length, null);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    if (SymbolInserter.this._bracketLevelStack.size() == 0) {
                        document.removePositionUpdater(SymbolInserter.this._updater);
                        try {
                            document.removePositionCategory(SymbolInserter.this.CATEGORY);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {}
                    }
                }
            });
        }
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }

    public static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    public static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char _exitCharacter;
        final char _escapeCharacter;
        final Stack _stack;
        final int _size;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this._exitCharacter = exitCharacter;
            this._escapeCharacter = escapeCharacter;
            this._stack = stack;
            this._size = this._stack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == this._exitCharacter && this._size == this._stack.size() && !this.isMasked(offset)) {
                SymbolLevel level = (SymbolLevel)this._stack.peek();
                if (level._firstPosition.offset > offset || level._secondPosition.offset < offset) {
                    return null;
                }
                if (level._secondPosition.offset == offset && length == 0) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = SymbolInserter.this._sqlEditor.getSV().getDocument();
            try {
                return this._escapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    private static class SymbolLevel {
        int _offset;
        int _length;
        LinkedModeUI _uI;
        Position _firstPosition;
        Position _secondPosition;

        private SymbolLevel() {
        }
    }
}

