/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.FindSupport;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;

public final class FileLocator {
    private FileLocator() {
    }

    public static URL find(Bundle bundle, IPath path, Map<String, String> override) {
        return FindSupport.find(bundle, path, override);
    }

    public static URL find(Bundle bundle, IPath path) {
        return FindSupport.find(bundle, path, null);
    }

    public static URL[] findEntries(Bundle bundle, IPath path, Map<String, String> override) {
        return FindSupport.findEntries(bundle, path, override);
    }

    public static URL find(URL url) {
        return FindSupport.find(url);
    }

    public static URL[] findEntries(Bundle bundle, IPath path) {
        return FindSupport.findEntries(bundle, path);
    }

    public static InputStream openStream(Bundle bundle, IPath file, boolean substituteArgs) throws IOException {
        return FindSupport.openStream(bundle, file, substituteArgs);
    }

    public static URL toFileURL(URL url) throws IOException {
        URLConverter converter = Activator.getURLConverter(url);
        return converter == null ? url : converter.toFileURL(url);
    }

    public static URL resolve(URL url) throws IOException {
        URLConverter converter = Activator.getURLConverter(url);
        return converter == null ? url : converter.resolve(url);
    }

    @Deprecated(since="3.16.100")
    public static File getBundleFile(Bundle bundle) throws IOException {
        return FileLocator.getBundleFileLocation(bundle).orElseThrow(() -> new IOException("Unable to locate the bundle file: " + bundle));
    }

    public static Optional<File> getBundleFileLocation(Bundle bundle) {
        return Optional.ofNullable(bundle.adapt(File.class));
    }
}

