/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.SubtreeModelScope;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.specification.AbstractScopeDefinition;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EObjectScopeDefinition
extends AbstractScopeDefinition {
    public EObjectScopeDefinition(EObject element_p, String label_p, boolean editable_p) {
        super(element_p, label_p != null ? label_p : EObjectScopeDefinition.getLabelForElement(element_p), editable_p);
    }

    public IEditableModelScope createScope(Object context_p) {
        return new SubtreeModelScope(this.getEntrypoint());
    }

    public EObject getEntrypoint() {
        return (EObject)super.getEntrypoint();
    }

    protected static String getLabelForElement(EObject element_p) {
        String result = UIUtil.getEMFText(element_p);
        if (result == null) {
            result = element_p.toString();
        } else {
            URI uri;
            Resource resource = element_p.eResource();
            if (resource != null && (uri = resource.getURI()) != null) {
                String resourceName = UIUtil.simplifyURI(uri);
                result = String.format(Messages.EObjectScopeDefinition_LabelInResource, result, resourceName);
            }
        }
        return result;
    }
}

