/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers;

import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public class DirectedComparisonViewer
extends ComparisonViewer {
    private final boolean _isLeftToRight;

    public DirectedComparisonViewer(Composite parent_p) {
        this(parent_p, null);
    }

    public DirectedComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        this(parent_p, actionBars_p, true);
    }

    public DirectedComparisonViewer(Composite parent_p, IActionBars actionBars_p, boolean isLeftToRight_p) {
        super(parent_p, actionBars_p);
        this._isLeftToRight = isLeftToRight_p;
    }

    protected boolean acceptContextMenuAdditions(Viewer viewer_p) {
        return false;
    }

    protected Action createActionAccept() {
        final Action result = new Action(){

            public String getText() {
                return DirectedComparisonViewer.this.isLeftToRight() ? Messages.ComparisonViewer_MergeRightTooltip : Messages.ComparisonViewer_MergeLeftTooltip;
            }

            public ImageDescriptor getImageDescriptor() {
                return DirectedComparisonViewer.this.isLeftToRight() ? EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.CHECKIN_ACTION) : EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.CHECKOUT_ACTION);
            }

            public void run() {
                DirectedComparisonViewer.this.merge(!DirectedComparisonViewer.this.isLeftToRight(), true);
            }
        };
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                boolean leftToRight = DirectedComparisonViewer.this.isLeftToRight();
                if ((!leftToRight && "PROPERTY_ACTIVATION_MERGE_TO_LEFT".equals(event_p.getProperty()) || leftToRight && "PROPERTY_ACTIVATION_MERGE_TO_RIGHT".equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        result.setEnabled(false);
        return result;
    }

    protected Action createActionAcceptDeletion() {
        final Action result = new Action(){

            public String getText() {
                return DirectedComparisonViewer.this.isLeftToRight() ? Messages.ComparisonViewer_DeleteRightTooltip : Messages.ComparisonViewer_DeleteLeftTooltip;
            }

            public void run() {
                DirectedComparisonViewer.this.merge(!DirectedComparisonViewer.this.isLeftToRight(), false);
            }
        };
        result.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.DELETE));
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue;
                boolean leftToRight = DirectedComparisonViewer.this.isLeftToRight();
                if ((!leftToRight && "PROPERTY_ACTIVATION_DELETE_LEFT".equals(event_p.getProperty()) || leftToRight && "PROPERTY_ACTIVATION_DELETE_RIGHT".equals(event_p.getProperty())) && (newValue = event_p.getNewValue()) instanceof Boolean) {
                    result.setEnabled(((Boolean)newValue).booleanValue());
                }
            }
        });
        result.setEnabled(false);
        return result;
    }

    protected Action createActionIgnore() {
        final IgnoreAction result = new IgnoreAction();
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                Object newValue = event_p.getNewValue();
                if (newValue instanceof Boolean) {
                    boolean boolValue = (Boolean)newValue;
                    String property = event_p.getProperty();
                    if ("PROPERTY_ACTIVATION_IGNORE_LEFT".equals(property)) {
                        result.setActiveLeft(boolValue);
                    } else if ("PROPERTY_ACTIVATION_IGNORE_RIGHT".equals(property)) {
                        result.setActiveRight(boolValue);
                    }
                }
            }
        });
        return result;
    }

    protected Role getResultingModelRole() {
        Role result = null;
        EMFDiffNode input = this.getInput();
        if (input != null) {
            result = input.getRoleForSide(!this.isLeftToRight());
        }
        return result;
    }

    protected void inputChanged(Object input_p, Object oldInput_p) {
        if (input_p instanceof EMFDiffNode) {
            EMFDiffNode node = (EMFDiffNode)((Object)input_p);
            node.setReferenceRole(node.getRoleForSide(!this.isLeftToRight()));
        }
        super.inputChanged(input_p, oldInput_p);
    }

    public boolean isLeftToRight() {
        return this._isLeftToRight;
    }

    protected void populateContextMenu(MenuManager menuManager_p, Viewer viewer_p, ISelectionProvider selectionProvider_p) {
        if (this._viewerSynthesisMain != null && viewer_p != this._viewerSynthesisMain.getInnerViewer()) {
            return;
        }
        final Action acceptAction = this.createActionAccept();
        final Action acceptDeletionAction = this.createActionAcceptDeletion();
        final Action ignoreAction = this.createActionIgnore();
        menuManager_p.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager_p) {
                if (acceptAction != null && acceptAction.isEnabled()) {
                    manager_p.add((IAction)acceptAction);
                }
                if (acceptDeletionAction != null && acceptDeletionAction.isEnabled()) {
                    manager_p.add((IAction)acceptDeletionAction);
                }
                if (ignoreAction != null && ignoreAction.isEnabled()) {
                    manager_p.add((IAction)ignoreAction);
                }
            }
        });
    }

    protected class IgnoreAction
    extends Action {
        private boolean _activeLeft;
        private boolean _activeRight;

        public IgnoreAction() {
            super(Messages.DirectedComparisonViewer_Ignore);
            this._activeLeft = false;
            this._activeRight = false;
            this.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.CHECKED));
        }

        public void run() {
            if (this._activeLeft) {
                DirectedComparisonViewer.this.ignore(true);
            }
            if (this._activeRight) {
                DirectedComparisonViewer.this.ignore(false);
            }
        }

        public void setActiveLeft(boolean activeLeft_p) {
            this._activeLeft = activeLeft_p;
            this.update();
        }

        public void setActiveRight(boolean activeRight_p) {
            this._activeRight = activeRight_p;
            this.update();
        }

        protected void update() {
            this.setEnabled(this._activeLeft || this._activeRight);
        }
    }
}

