/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util.structures;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.HashBinaryRelation;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.util.structures.IInvertibleBinaryRelation;
import org.eclipse.emf.diffmerge.util.structures.IRangedBinaryRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashInvertibleBinaryRelation<T, U>
extends HashBinaryRelation<T, U>
implements IInvertibleBinaryRelation<T, U> {
    protected final IRangedBinaryRelation.Editable<U, T> _inverse;

    public HashInvertibleBinaryRelation(IEqualityTester tester_p) {
        super(tester_p);
        this._inverse = new HashBinaryRelation<U, T>(tester_p);
    }

    public HashInvertibleBinaryRelation() {
        this(null);
    }

    @Override
    public boolean add(T source_p, U target_p) {
        boolean result = super.add(source_p, target_p);
        if (result) {
            this._inverse.add(target_p, source_p);
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this._inverse.clear();
    }

    @Override
    public List<T> getInverse(U element_p) {
        return this._inverse.get(element_p);
    }

    @Override
    public Collection<U> getTargets() {
        return this._inverse.getSources();
    }

    @Override
    public boolean remove(T source_p, U target_p) {
        boolean result = super.remove(source_p, target_p);
        if (result) {
            this._inverse.remove(target_p, source_p);
        }
        return result;
    }

    @Override
    public boolean removeSource(T source_p) {
        FArrayList targets = new FArrayList(this.get((Object)source_p), this.getEqualityTester());
        boolean result = super.removeSource(source_p);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            Object target = iterator.next();
            this._inverse.remove(target, source_p);
        }
        return result;
    }

    @Override
    public boolean removeTarget(U target_p) {
        FArrayList sources = new FArrayList(this.getInverse((Object)target_p), this.getEqualityTester());
        boolean result = this._inverse.removeSource(target_p);
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            Object source = iterator.next();
            this.remove(source, target_p);
        }
        return result;
    }
}

