/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.ed.view;

import java.util.ArrayList;
import org.eclipse.dirigible.ide.template.ui.ed.view.ExtensionsView;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionDefinition;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionManager;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionPointDefinition;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class ExtensionsContentProvider
implements ITreeContentProvider {
    private static final long serialVersionUID = -1334098123002372113L;
    private static final Logger logger = Logger.getLogger(ExtensionsContentProvider.class);
    private ExtensionManager extensionManager;
    private Shell shell;

    public ExtensionsContentProvider(ExtensionManager extensionManager, Shell shell) {
        this.extensionManager = extensionManager;
        this.shell = shell;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<ExtensionPointDefinition> elements = new ArrayList<ExtensionPointDefinition>();
        try {
            String[] stringArray = this.extensionManager.getExtensionPoints();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nextExtensionPoint = stringArray[n2];
                elements.add(this.extensionManager.getExtensionPoint(nextExtensionPoint));
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error(ExtensionsView.EXTENSIONS_ERROR, (Throwable)e);
            MessageDialog.openError((Shell)this.shell, (String)ExtensionsView.EXTENSIONS_ERROR, (String)e.getMessage());
        }
        return elements.toArray(new ExtensionPointDefinition[elements.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<ExtensionDefinition> children = new ArrayList<ExtensionDefinition>();
        if (parentElement instanceof ExtensionPointDefinition) {
            try {
                String[] extensions;
                ExtensionPointDefinition extensionPoint = (ExtensionPointDefinition)parentElement;
                String[] stringArray = extensions = this.extensionManager.getExtensions(extensionPoint.getLocation());
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String nextExtension = stringArray[n2];
                    children.add(this.extensionManager.getExtension(nextExtension, extensionPoint.getLocation()));
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error(ExtensionsView.EXTENSIONS_ERROR, (Throwable)e);
                MessageDialog.openError((Shell)this.shell, (String)ExtensionsView.EXTENSIONS_ERROR, (String)e.getMessage());
            }
        }
        return children.toArray(new ExtensionDefinition[children.size()]);
    }

    public Object getParent(Object element) {
        ExtensionPointDefinition parent = null;
        if (element instanceof ExtensionDefinition) {
            try {
                parent = this.extensionManager.getExtensionPoint(((ExtensionDefinition)element).getExtensionPoint());
            }
            catch (Exception e) {
                logger.error(ExtensionsView.EXTENSIONS_ERROR, (Throwable)e);
                MessageDialog.openError((Shell)this.shell, (String)ExtensionsView.EXTENSIONS_ERROR, (String)e.getMessage());
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ExtensionPointDefinition;
    }
}

