/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.java.dynamic.compilation.ClassFileManager;
import org.eclipse.dirigible.runtime.java.dynamic.compilation.InMemoryCompilationException;
import org.eclipse.dirigible.runtime.java.dynamic.compilation.InMemoryDiagnosticListener;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;

public class JavaExecutor
extends AbstractScriptExecutor {
    private static final Logger logger = Logger.getLogger(JavaExecutor.class);
    private static final String JAVA_EXTENSION = ".java";
    private static final String CLASSPATH = "-classpath";
    public static final String JAVA_TOOLS_COMPILER = "JAVA_TOOLS_COMPILER";
    private IRepository repository;
    private String[] rootPaths;
    private Map<String, Object> defaultVariables;
    private String classpath;

    public JavaExecutor(IRepository repository, String classpath, String ... rootPaths) {
        this.repository = repository;
        this.rootPaths = rootPaths;
        this.defaultVariables = new HashMap<String, Object>();
        this.classpath = classpath;
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws InMemoryCompilationException {
        try {
            this.registerDefaultVariables(request, response, input, null, this.repository, null);
            ClassFileManager fileManager = this.compile(request);
            return this.execute(request, response, module, fileManager);
        }
        catch (Throwable t) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            logger.error(t.getMessage(), t);
            throw new InMemoryCompilationException(baos.toString());
        }
    }

    private ClassFileManager compile(HttpServletRequest request) throws IOException, ClassNotFoundException, URISyntaxException {
        List<JavaFileObject> sourceFiles = ClassFileManager.getSourceFiles(this.retrieveModulesByExtension(this.repository, JAVA_EXTENSION, this.rootPaths));
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new InMemoryCompilationException("Use JDK instead of JRE");
        }
        InMemoryDiagnosticListener diagnosticListener = new InMemoryDiagnosticListener();
        ClassFileManager fileManager = ClassFileManager.getInstance(compiler.getStandardFileManager(diagnosticListener, null, null));
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, diagnosticListener, Arrays.asList(CLASSPATH, this.getClasspath()), null, sourceFiles);
        Boolean compilationTaskResult = compilationTask.call();
        if (compilationTaskResult == null || !compilationTaskResult.booleanValue()) {
            throw new InMemoryCompilationException(diagnosticListener);
        }
        return fileManager;
    }

    public String getClasspath() {
        return this.classpath;
    }

    private Object execute(HttpServletRequest request, HttpServletResponse response, String module, ClassFileManager fileManager) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> loadedClass = fileManager.getClassLoader(null).loadClass(ClassFileManager.getFQN(module));
        Class[] inputParameters = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Map.class};
        Method serviceMethod = loadedClass.getMethod("service", inputParameters);
        return serviceMethod.invoke(loadedClass.newInstance(), request, response, this.defaultVariables);
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
        this.defaultVariables.put(name, value);
    }

    protected String getModuleType(String path) {
        return "ScriptingServices";
    }
}

