/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.rap.menu.perspectives;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PerspectivesContribution
extends ContributionItem {
    private static final long serialVersionUID = -3527023849776289881L;
    private static final String KEY_PERSPECTIVE_DESCR = "k_p_descr";

    public PerspectivesContribution() {
    }

    public PerspectivesContribution(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        IPerspectiveDescriptor[] perspectives;
        String activePerspectiveId = this.getActivePerspectiveId();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectives = this.getPerspectives();
        int n = perspectives.length;
        int n2 = 0;
        while (n2 < n) {
            final IPerspectiveDescriptor descriptor = iPerspectiveDescriptorArray[n2];
            MenuItem item = new MenuItem(menu, 16);
            item.setData(KEY_PERSPECTIVE_DESCR, (Object)descriptor);
            item.setText(descriptor.getLabel());
            Image image = descriptor.getImageDescriptor().createImage();
            item.setImage(image);
            if (descriptor.getId().equals(activePerspectiveId)) {
                item.setSelection(true);
            }
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private static final long serialVersionUID = 6280318786385936319L;

                public void widgetSelected(SelectionEvent e) {
                    PerspectivesContribution.this.handlePerspectiveSelected(descriptor);
                }
            });
            ++n2;
        }
    }

    private String getActivePerspectiveId() {
        IWorkbenchPage page = this.getActivePage();
        if (page == null) {
            return null;
        }
        IPerspectiveDescriptor descriptor = page.getPerspective();
        if (descriptor == null) {
            return null;
        }
        return descriptor.getId();
    }

    private IPerspectiveDescriptor[] getPerspectives() {
        return PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
    }

    private void handlePerspectiveSelected(IPerspectiveDescriptor descriptor) {
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            page.setPerspective(descriptor);
        }
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        return activeWindow.getActivePage();
    }

    public boolean isDynamic() {
        return true;
    }
}

