/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.impl;

import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dirigible.ide.workspace.impl.Container;
import org.eclipse.dirigible.ide.workspace.impl.File;
import org.eclipse.dirigible.ide.workspace.impl.Messages;
import org.eclipse.dirigible.ide.workspace.impl.Resource;
import org.eclipse.dirigible.ide.workspace.impl.Workspace;
import org.eclipse.dirigible.ide.workspace.impl.event.ResourceChangeEvent;
import org.eclipse.dirigible.repository.logging.Logger;

public class Folder
extends Container
implements IFolder {
    private static final String LINKED_FOLDERS_ARE_NOT_SUPPORTED2 = Messages.Folder_LINKED_FOLDERS_ARE_NOT_SUPPORTED2;
    private static final String LINKED_FOLDERS_ARE_NOT_SUPPORTED = Messages.Folder_LINKED_FOLDERS_ARE_NOT_SUPPORTED;
    private static final String COULD_NOT_CREATE_FOLDER = Messages.Folder_COULD_NOT_CREATE_FOLDER;
    private static final String PROJECT_IS_NOT_OPEN = Messages.Folder_PROJECT_IS_NOT_OPEN;
    private static final String PARENT_DOES_NOT_EXIST = Messages.Folder_PARENT_DOES_NOT_EXIST;
    private static final String A_RESOURCE_WITH_THIS_PATH_EXISTS = Messages.Folder_A_RESOURCE_WITH_THIS_PATH_EXISTS;
    private static final Logger logger = Logger.getLogger(Folder.class);

    public Folder(IPath path, Workspace workspace) {
        super(path, workspace);
    }

    public void create(boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        this.create(force ? 1 : 0, local, monitor);
    }

    public void create(int updateFlags, boolean local, IProgressMonitor monitor) throws CoreException {
        monitor = Resource.monitorWrapper(monitor);
        try {
            monitor.beginTask("folder creation", -1);
            IStatus pathValidation = this.workspace.validatePath(this.path.toString(), 2);
            if (!pathValidation.isOK()) {
                throw new CoreException(pathValidation);
            }
            if (this.workspace.hasResource(this.getLocation())) {
                throw new CoreException(Folder.createErrorStatus(A_RESOURCE_WITH_THIS_PATH_EXISTS));
            }
            if (!this.getParent().exists()) {
                throw new CoreException(Folder.createErrorStatus(PARENT_DOES_NOT_EXIST));
            }
            if (!this.getProject().isOpen()) {
                throw new CoreException(Folder.createErrorStatus(PROJECT_IS_NOT_OPEN));
            }
            try {
                this.getEntity().create();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new CoreException(Folder.createErrorStatus(COULD_NOT_CREATE_FOLDER));
            }
            this.workspace.notifyResourceChanged(new ResourceChangeEvent(this, 1));
        }
        finally {
            monitor.done();
        }
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(LINKED_FOLDERS_ARE_NOT_SUPPORTED);
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(LINKED_FOLDERS_ARE_NOT_SUPPORTED2);
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int flags = (keepHistory ? 2 : 0) | (force ? 1 : 0);
        this.delete(flags, monitor);
    }

    public IFile getFile(String name) {
        IPath resourcePath = this.path.append(name);
        return new File(resourcePath, this.workspace);
    }

    public IFolder getFolder(String name) {
        IPath resourcePath = this.path.append(name);
        return new Folder(resourcePath, this.workspace);
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int flags = (keepHistory ? 2 : 0) | (force ? 1 : 0);
        this.move(destination, flags, monitor);
    }
}

