/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.swt.internal.widgets.ValidationStrategy;

public class ExtensionValidationStrategy
implements ValidationStrategy {
    private String[] filterExtensions;
    private int filterIndex;

    public ExtensionValidationStrategy(String[] filterExtensions, int filterIndex) {
        this.filterExtensions = filterExtensions;
        this.filterIndex = filterIndex;
    }

    @Override
    public boolean validate(String filename) {
        boolean valid = true;
        if (this.filterExtensions != null && filename.length() > 0 && this.filterIndex < this.filterExtensions.length) {
            valid = false;
            String filter = this.filterExtensions[this.filterIndex];
            if (filter != null) {
                String[] types = filter.split(";");
                int j = 0;
                while (j < types.length) {
                    String ext = types[j].replaceAll("\\*", "");
                    if (ext.equals(".") || filename.endsWith(ext)) {
                        valid = true;
                    }
                    ++j;
                }
            }
        }
        return valid;
    }
}

