/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.sql;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptingServlet;
import org.eclipse.dirigible.runtime.sql.SQLExecutor;

public class SQLServlet
extends AbstractScriptingServlet {
    private static final long serialVersionUID = -2029496922201773270L;
    private static final Logger logger = Logger.getLogger(SQLServlet.class);
    private File libDirectory;
    private static String classpath;

    protected void doExecution(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String module = request.getPathInfo();
        SQLExecutor executor = this.createExecutor(request);
        HashMap executionContext = new HashMap();
        try {
            response.setContentType("application/json;charset=UTF-8");
            String result = (String)executor.executeServiceModule(request, response, module, executionContext);
            response.getWriter().println(result);
            response.getWriter().flush();
            response.getWriter().close();
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
    }

    public SQLExecutor createExecutor(HttpServletRequest request) throws IOException {
        SQLExecutor executor = new SQLExecutor(this.getRepository(request), this.getScriptingRegistryPath(request), "/db/dirigible/registry/public/ScriptingServices");
        return executor;
    }
}

