/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.job;

import com.google.gson.Gson;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.ext.utils.InstanceUtils;
import org.eclipse.dirigible.repository.ext.utils.JsonUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.job.Job;
import org.eclipse.dirigible.runtime.job.log.JobLog;
import org.eclipse.dirigible.runtime.job.log.JobLogRecordDAO;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.utils.EngineUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CronJob
implements org.quartz.Job {
    private static final Logger logger = Logger.getLogger(CronJob.class);
    private static Gson gson = new Gson();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.debug("Starting Job...");
        String instName = context.getJobDetail().getName();
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String jobName = dataMap.getString("name");
        String jobType = dataMap.getString("type");
        String jobDescription = dataMap.getString("description");
        String jobExpression = dataMap.getString("expression");
        String jobModule = dataMap.getString("module");
        Job job = new Job();
        job.setName(jobName);
        job.setDescription(jobDescription);
        job.setExpression(jobExpression);
        job.setModule(jobModule);
        job.setType(jobType);
        logger.debug(String.format("Job processing name: %s, type: %s, module: %s ...", instName, jobType, jobModule));
        HashMap<Object, Object> executionContext = new HashMap<Object, Object>();
        Object inputOutput = null;
        inputOutput = CronJob.executeByEngineType(null, null, jobModule, executionContext, job, inputOutput);
        logger.debug(String.format("Job name: %s, type: %s, module: %s finished.", job.getName(), jobType, jobModule));
    }

    public static Object executeByEngineType(HttpServletRequest request, HttpServletResponse response, String module, Map<Object, Object> executionContext, Job job, Object inputOutput) {
        CronJob.logJob(job, executionContext, 1, "");
        try {
            Set types = EngineUtils.getTypes();
            for (String type : types) {
                if (type == null || !type.equalsIgnoreCase(job.getType())) continue;
                IScriptExecutor scriptExecutor = EngineUtils.createExecutor((String)type, (HttpServletRequest)request);
                scriptExecutor.executeServiceModule(request, response, module, executionContext);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            CronJob.logJob(job, executionContext, 2, e.getMessage());
        }
        CronJob.logJob(job, executionContext, 3, "");
        return inputOutput;
    }

    private static void logJob(Job job, Map<Object, Object> executionContext, int status, String message) {
        JobLog jobLog = new JobLog();
        jobLog.setInstance(InstanceUtils.getInstanceName());
        jobLog.setJobName(job.getName());
        jobLog.setJobUUID(job.getJobUUID());
        jobLog.setStatus(status);
        jobLog.setMessage(message);
        jobLog.setContext(JsonUtils.mapToJson(executionContext));
        try {
            JobLogRecordDAO.insert(jobLog);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

