/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;

public class AnonymousUserServlet
extends HttpServlet {
    private static final long serialVersionUID = 3669759124907091014L;
    private static final Logger logger = Logger.getLogger(AnonymousUserServlet.class);
    private static final String REGEX_USER_NAME = "[A-Za-z0-9_]{3,64}";
    private static final Pattern PATTERN_USER_NAME = Pattern.compile("[A-Za-z0-9_]{3,64}");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cookieValue = null;
        String userName = req.getParameter("user");
        if (userName != null && !userName.isEmpty()) {
            Matcher userNameMatcher = PATTERN_USER_NAME.matcher(userName = userName.trim());
            if (!userNameMatcher.matches()) {
                logger.error("The provided username <" + userName + "> is invalid. It must match: " + REGEX_USER_NAME);
                resp.sendError(400, "Invalid user name: " + userName);
                return;
            }
            this.setCookieUser(resp, userName);
            cookieValue = userName;
        } else {
            Cookie[] cookies = req.getCookies();
            String cookieName = "dirigible_anonymous_user";
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookieName.equals(cookie.getName())) {
                    cookieValue = cookie.getValue();
                    break;
                }
                ++n2;
            }
            if (cookieValue == null) {
                logger.error("User has not been provided neither as cookie nor as parameter");
                resp.sendError(400, "Use .../anonymous?user=xxx");
                return;
            }
            Matcher cookieUserNameMatcher = PATTERN_USER_NAME.matcher(cookieValue);
            if (!cookieUserNameMatcher.matches()) {
                logger.error("Invalid user name was provided as cookie: " + cookieValue);
                resp.sendError(400, "Invalid cookie.");
                return;
            }
        }
        String redirect = req.getParameter("redirect");
        if (redirect != null && !"".equals(redirect.trim())) {
            String git = req.getParameter("git");
            if (git != null && !"".equals(git.trim())) {
                resp.sendRedirect("index.html?perspective=workspace&git=" + git);
            } else {
                resp.sendRedirect("ui/index.html");
            }
        } else {
            resp.getWriter().println(cookieValue);
            resp.getWriter().flush();
            resp.getWriter().close();
        }
    }

    private void setCookieUser(HttpServletResponse resp, String userName) {
        Cookie cookie = new Cookie("dirigible_anonymous_user", userName);
        cookie.setMaxAge(2592000);
        cookie.setPath("/");
        resp.addCookie(cookie);
    }
}

