/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractWorkspaceHandler;
import org.eclipse.dirigible.ide.workspace.wizard.project.commands.Messages;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class UploadProjectHandler
extends AbstractWorkspaceHandler {
    private static final String THIS_PROCESS_WILL_OVERRIDE_YOUR_EXISTING_PROJECTS_DO_YOU_WANT_TO_CONTINUE = Messages.UploadProjectHandler_THIS_PROCESS_WILL_OVERRIDE_YOUR_EXISTING_PROJECTS_DO_YOU_WANT_TO_CONTINUE;
    private static final String OVERRIDE_PROJECTS = Messages.UploadProjectHandler_OVERRIDE_PROJECTS;
    private static final String CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE = Messages.UploadProjectHandler_CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE;
    private static final String UPLOAD_ERROR = Messages.UploadProjectHandler_UPLOAD_ERROR;
    private static final String REASON = Messages.UploadProjectHandler_REASON;
    private static final String CANNOT_UPLOAD = Messages.UploadProjectHandler_CANNOT_UPLOAD;
    private static final String CANNOT_SAVE_UPLOADED_FILE = Messages.UploadProjectHandler_CANNOT_SAVE_UPLOADED_FILE;
    private static final String UPLOAD_PROJECT_ARCHIVE = Messages.UploadProjectHandler_UPLOAD_PROJECT_ARCHIVE;
    private static final Logger error = Logger.getLogger(UploadProjectHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dlg = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 34);
        dlg.setText(UPLOAD_PROJECT_ARCHIVE);
        String projectPath = dlg.open();
        if (projectPath != null && MessageDialog.openConfirm(null, (String)OVERRIDE_PROJECTS, (String)THIS_PROCESS_WILL_OVERRIDE_YOUR_EXISTING_PROJECTS_DO_YOU_WANT_TO_CONTINUE)) {
            String fileName = null;
            String[] stringArray = dlg.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block16: {
                    String fullFileName = stringArray[n2];
                    fileName = fullFileName.substring(fullFileName.lastIndexOf(File.separatorChar) + 1);
                    FileInputStream in = null;
                    try {
                        try {
                            in = new FileInputStream(fullFileName);
                            IRepository repository = RepositoryFacade.getInstance().getRepository();
                            IWorkspace workspace = WorkspaceLocator.getWorkspace();
                            String root = WorkspaceLocator.getRepositoryPathForWorkspace((IWorkspace)workspace);
                            repository.importZip(new ZipInputStream(in), root);
                            this.refreshWorkspace();
                        }
                        catch (Exception e) {
                            error.error(String.valueOf(CANNOT_SAVE_UPLOADED_FILE) + fileName, (Throwable)e);
                            MessageDialog.openError(null, (String)UPLOAD_ERROR, (String)(String.valueOf(CANNOT_UPLOAD) + fileName + REASON + e.getMessage()));
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException e2) {
                                    error.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e2);
                                }
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException e) {
                                error.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            error.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

