/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import org.eclipse.dirigible.repository.datasource.db.dialect.RDBGenericDialectSpecifier;

public class DerbyDBSpecifier
extends RDBGenericDialectSpecifier {
    private static final String PRODUCT_DERBY = "Apache Derby";
    private static final String OFFSET_D_ROWS_FETCH_FIRST_D_ROWS_ONLY = "OFFSET %d ROWS FETCH FIRST %d ROWS ONLY";
    private static final String DERBY_TIMESTAMP = "TIMESTAMP";
    private static final String DERBY_FLOAT = "DOUBLE";
    private static final String DERBY_BLOB = "BLOB";
    private static final String DERBY_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    private static final String DERBY_KEY_VARCHAR = "VARCHAR(1000)";
    private static final String DERBY_BIG_VARCHAR = "VARCHAR(4000)";

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(OFFSET_D_ROWS_FETCH_FIRST_D_ROWS_ONLY, offset, limit);
    }

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", DERBY_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", DERBY_TIMESTAMP);
        sql = sql.replace("$BLOB$", DERBY_BLOB);
        sql = sql.replace("$KEY_VARCHAR$", DERBY_KEY_VARCHAR);
        sql = sql.replace("$BIG_VARCHAR$", DERBY_BIG_VARCHAR);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("FLOAT".equals(commonType)) {
            return DERBY_FLOAT;
        }
        return commonType;
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD ";
    }

    @Override
    public boolean isDialectForName(String productName) {
        return PRODUCT_DERBY.equalsIgnoreCase(productName);
    }
}

