/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.datasource.db.dialect.IDialectSpecifier;

public class RDBGenericDialectSpecifier
implements IDialectSpecifier {
    private static final String DOT = ".";
    private static final String QUOTES = "\"";
    private static final String EMPTY = "";

    public String specify(String sql) {
        return sql;
    }

    public String getSpecificType(String commonType) {
        return commonType;
    }

    public String createLimitAndOffset(int limit, int offset) {
        return EMPTY;
    }

    public String createTopAndStart(int limit, int offset) {
        return EMPTY;
    }

    public boolean isSchemaFilterSupported() {
        return false;
    }

    public String getSchemaFilterScript() {
        return null;
    }

    public String getAlterAddOpen() {
        return EMPTY;
    }

    public String getAlterAddOpenEach() {
        return EMPTY;
    }

    public String getAlterAddClose() {
        return EMPTY;
    }

    public String getAlterAddCloseEach() {
        return EMPTY;
    }

    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        Blob data = resultSet.getBlob(columnName);
        return data.getBinaryStream();
    }

    public boolean isCatalogForSchema() {
        return false;
    }

    public boolean isSchemaless() {
        return false;
    }

    public boolean isDialectForName(String productName) {
        return false;
    }

    public String getContentQueryScript(String catalogName, String schemaName, String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        String q = "SELECT * FROM ";
        String tableFqn = String.valueOf(schemaName != null ? QUOTES + schemaName + QUOTES + DOT : EMPTY) + QUOTES + tableName + QUOTES;
        return String.valueOf(q) + tableFqn;
    }
}

