/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.dirigible.repository.datasource.Messages;
import org.eclipse.dirigible.repository.datasource.WrappedDataSource;
import org.eclipse.dirigible.repository.logging.Logger;

public class DataSourceFacade {
    private static final String EMPTY = "";
    private static final String EMBEDDED_DATA_SOURCE_IS_USED = Messages.DataSourceFacade_EMBEDDED_DATA_SOURCE_IS_USED;
    private static final String LOCAL_DB_ACTION = "create";
    private static final String LOCAL_DB_NAME = "derby";
    private static final String DATASOURCE_DEFAULT = "DEFAULT_DATASOURCE";
    private static final String DEFAULT_DATASOURCE_TYPE = "defaultDataSourceType";
    private static final String DEFAULT_DATASOURCE_TYPE_JNDI = "jndi";
    private static final String DEFAULT_DATASOURCE_TYPE_LOCAL = "local";
    private static final String JNDI_DEFAULT_DATASOURCE = "jndiDefaultDataSource";
    public static final String DATASOURCE_PREFIX = "DATASOURCE_";
    public static final String PARAM_DB_ID = "db.id";
    public static final String PARAM_DB_NAME = "db.name";
    public static final String PARAM_DB_TYPE = "db.type";
    public static final String PARAM_DB_LOC = "db.location";
    public static final String PARAM_DB_DRIVER = "db.driver";
    public static final String PARAM_DB_USER = "db.user";
    public static final String PARAM_DB_PASSWORD = "db.password";
    public static final String PARAM_DB_AUTO_COMMIT = "db.auto-commit";
    public static final String PARAM_DB_AUTO_MAX_ACTIVE = "db.max-active";
    public static final String PARAM_DB_AUTO_MAX_IDLE = "db.max-idle";
    public static final String PARAM_DB_AUTO_MAX_WAIT = "db.max-wait";
    public static final String PARAM_DB_TYPE_JNDI = "jndi";
    public static final String PARAM_DB_TYPE_DIRECT = "direct";
    public static final Logger logger = Logger.getLogger((String)DataSourceFacade.class.getCanonicalName());
    private static DataSource localDataSource;
    private static DataSourceFacade instance;
    private WrappedDataSource dataSource;
    private static Map<String, Properties> namedDataSources;

    static {
        namedDataSources = Collections.synchronizedMap(new HashMap());
    }

    public static DataSourceFacade getInstance() {
        if (instance == null) {
            instance = new DataSourceFacade();
        }
        return instance;
    }

    public DataSource getDataSource(HttpServletRequest request) {
        if (this.dataSource == null) {
            logger.debug("Lookup Datasource...");
            if (request == null) {
                logger.debug("No request - try from Env...");
                this.dataSource = this.getFromEnv();
            } else {
                logger.debug("Request exists - try from Request...");
                this.dataSource = this.getFromSession(request);
            }
            if (this.dataSource == null) {
                logger.debug("Try from Context...");
                String jndiName = System.getProperty(JNDI_DEFAULT_DATASOURCE);
                this.dataSource = (WrappedDataSource)this.getFromContext(jndiName, true);
            }
            if (this.dataSource == null) {
                this.dataSource = this.createLocal();
                logger.warn("Created Local DataSource!");
            } else {
                logger.debug("Lookup done.");
            }
        }
        return this.dataSource;
    }

    private WrappedDataSource getFromSession(HttpServletRequest request) {
        logger.debug("Try to get datasource from the Request");
        DataSource dataSource = null;
        dataSource = (DataSource)request.getSession().getAttribute(DATASOURCE_DEFAULT);
        if (dataSource != null) {
            WrappedDataSource wrappedDataSource = new WrappedDataSource(dataSource);
            logger.debug("Datasource retrieved from the Request");
            return wrappedDataSource;
        }
        logger.debug("Datasource NOT available in the Request");
        return null;
    }

    private WrappedDataSource getFromEnv() {
        logger.debug("Try to get datasource from System Properties");
        DataSource dataSource = null;
        dataSource = (DataSource)System.getProperties().get(DATASOURCE_DEFAULT);
        if (dataSource != null) {
            WrappedDataSource wrappedDataSource = new WrappedDataSource(dataSource);
            logger.debug("Datasource retrieved from System Properties");
            return wrappedDataSource;
        }
        logger.debug("Datasource NOT available in System Properties");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSource getFromContext(String jndiName, boolean wrap) {
        String defaultDataSourceType = System.getProperty(DEFAULT_DATASOURCE_TYPE);
        if (!"jndi".equalsIgnoreCase(defaultDataSourceType)) {
            logger.warn("Getting from Context not possible - no configured default DataSource as initial parameter");
            return null;
        }
        logger.debug("Try to get datasource from the InitialContext");
        try {
            InitialContext context = (InitialContext)System.getProperties().get("InitialContext");
            if (context == null) return null;
            if (jndiName == null) {
                return null;
            }
            DataSource datasource = (DataSource)context.lookup(jndiName);
            if (datasource == null) {
                logger.error("Could not find DataSource in Initial Context by name: " + jndiName);
                return null;
            }
            Connection con = null;
            try {
                try {
                    con = datasource.getConnection();
                }
                catch (Exception e) {
                    logger.error("Datasource retrieved from InitialContext, but it is broken - not bound to a real database", (Throwable)e);
                    if (con == null) return null;
                    con.close();
                    return null;
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
            if (wrap) {
                WrappedDataSource wrappedDataSource = new WrappedDataSource(datasource);
                logger.debug("Datasource retrieved from InitialContext and wrapped");
                return wrappedDataSource;
            }
            logger.debug("Datasource retrieved from InitialContext and returned unwrapped");
            return datasource;
        }
        catch (Throwable e) {
            logger.error("Could not find DataSource", e);
        }
        return null;
    }

    private WrappedDataSource createLocal() {
        logger.debug("Try to create embedded datasource");
        localDataSource = (DataSource)System.getProperties().get(LOCAL_DB_NAME);
        if (localDataSource == null) {
            localDataSource = new EmbeddedDataSource();
            ((EmbeddedDataSource)localDataSource).setDatabaseName(LOCAL_DB_NAME);
            ((EmbeddedDataSource)localDataSource).setCreateDatabase(LOCAL_DB_ACTION);
            System.getProperties().put(LOCAL_DB_NAME, localDataSource);
        }
        logger.warn(EMBEDDED_DATA_SOURCE_IS_USED);
        WrappedDataSource wrappedDataSource = new WrappedDataSource(localDataSource);
        return wrappedDataSource;
    }

    public void registerDataSource(String name, Properties namedDataSource) {
        namedDataSources.put(name, namedDataSource);
        logger.debug(String.format("Datasource with name %s has been registered", name));
    }

    public DataSource getNamedDataSource(HttpServletRequest request, String name) {
        Properties properties = namedDataSources.get(name);
        if (properties == null) {
            logger.error(String.format("Named DataSource %s is not configured in the Repository.", name));
            return null;
        }
        String id = properties.getProperty(PARAM_DB_ID);
        String type = properties.getProperty(PARAM_DB_TYPE);
        String loc = properties.getProperty(PARAM_DB_LOC);
        DataSource namedDataSource = null;
        if (request != null) {
            String nameInSession = DATASOURCE_PREFIX + id;
            namedDataSource = (DataSource)request.getSession().getAttribute(nameInSession);
            if (namedDataSource == null) {
                if ("jndi".equals(type)) {
                    namedDataSource = this.getFromContext(loc, false);
                    if (namedDataSource != null) {
                        request.getSession().setAttribute(nameInSession, (Object)namedDataSource);
                    } else {
                        logger.error(String.format("Named DataSource %s has not been injected in the request's session. Check the initial parameters.", nameInSession));
                    }
                } else if (PARAM_DB_TYPE_DIRECT.equals(type)) {
                    namedDataSource = this.createDirectDataSource(properties);
                    if (namedDataSource != null) {
                        request.getSession().setAttribute(nameInSession, (Object)namedDataSource);
                    } else {
                        logger.error(String.format("Named DataSource %s cannot be created based on the configurations metadata", nameInSession));
                    }
                }
            }
        } else {
            namedDataSource = this.getFromContext(loc, false);
        }
        return namedDataSource;
    }

    private DataSource createDirectDataSource(Properties properties) {
        properties.getProperty(PARAM_DB_ID);
        properties.getProperty(PARAM_DB_NAME);
        String url = properties.getProperty(PARAM_DB_LOC);
        String driver = properties.getProperty(PARAM_DB_DRIVER);
        String user = properties.getProperty(PARAM_DB_USER);
        String password = properties.getProperty(PARAM_DB_PASSWORD);
        String defaultAutoCommit = properties.getProperty(PARAM_DB_AUTO_COMMIT);
        String maxActive = properties.getProperty(PARAM_DB_AUTO_MAX_ACTIVE);
        String maxIdle = properties.getProperty(PARAM_DB_AUTO_MAX_IDLE);
        String maxWait = properties.getProperty(PARAM_DB_AUTO_MAX_WAIT);
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(driver);
        basicDataSource.setUrl(url);
        basicDataSource.setUsername(user);
        basicDataSource.setPassword(password);
        basicDataSource.setDefaultAutoCommit(Boolean.parseBoolean(defaultAutoCommit));
        basicDataSource.setMaxActive(maxActive != null ? Integer.parseInt(maxActive) : 100);
        basicDataSource.setMaxIdle(maxIdle != null ? Integer.parseInt(maxIdle) : 30);
        basicDataSource.setMaxWait((long)(maxWait != null ? Integer.parseInt(maxWait) : 10000));
        return basicDataSource;
    }

    public Set<String> getNamedDataSourcesNames() {
        return namedDataSources.keySet();
    }

    public void unregisterDataSource(String name) {
        namedDataSources.remove(name);
    }

    public void unregisterAllDataSources() {
        namedDataSources.clear();
    }

    public Properties getNamedDataSourceConfig(String dsName) {
        return namedDataSources.get(dsName);
    }
}

