/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.dirigible.repository.velocity.Messages;
import org.eclipse.dirigible.repository.velocity.VelocityGeneratorException;

public class VelocityGenerator {
    private static final String COULD_NOT_EVALUATE_TEMPLATE = Messages.getString("VelocityGenerator.COULD_NOT_EVALUATE_TEMPLATE");
    private VelocityEngine engine = new VelocityEngine();

    public VelocityGenerator() {
        try {
            this.engine.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void generate(Reader in, Writer out, Map<String, Object> parameters, String tag) throws VelocityGeneratorException {
        try {
            try {
                VelocityContext context = new VelocityContext();
                this.prepareContextData(parameters, context);
                this.engine.evaluate((Context)context, out, tag, in);
                out.flush();
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new VelocityGeneratorException(COULD_NOT_EVALUATE_TEMPLATE, ex);
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public void generate(InputStream in, OutputStream out, Map<String, Object> parameters, String tag) throws VelocityGeneratorException {
        try {
            try {
                VelocityContext context = new VelocityContext();
                this.prepareContextData(parameters, context);
                InputStreamReader reader = new InputStreamReader(in);
                OutputStreamWriter writer = new OutputStreamWriter(out);
                this.engine.evaluate((Context)context, (Writer)writer, tag, (Reader)reader);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new VelocityGeneratorException(COULD_NOT_EVALUATE_TEMPLATE, ex);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new VelocityGeneratorException(COULD_NOT_EVALUATE_TEMPLATE, e);
            }
        }
    }

    public String generate(String in, Map<String, Object> parameters, String tag) throws VelocityGeneratorException {
        String result = "";
        try {
            VelocityContext context = new VelocityContext();
            this.prepareContextData(parameters, context);
            StringReader reader = new StringReader(in);
            StringWriter writer = new StringWriter();
            this.engine.evaluate((Context)context, (Writer)writer, tag, (Reader)reader);
            writer.flush();
            StringBuffer buff = writer.getBuffer();
            result = buff.toString();
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new VelocityGeneratorException(COULD_NOT_EVALUATE_TEMPLATE, ex);
        }
        return result;
    }

    private void prepareContextData(Map<String, Object> parameters, VelocityContext context) {
        if (parameters == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
    }
}

