/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.layout;

import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutDelayed;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutOptimizer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class EMFFormsSWTLayoutUtil {
    private static EMFFormsSWTLayoutOptimizer layoutOptimizer;

    private EMFFormsSWTLayoutUtil() {
    }

    private static synchronized EMFFormsSWTLayoutOptimizer getLayoutOptimizer() {
        if (layoutOptimizer == null) {
            Bundle bundle = FrameworkUtil.getBundle(EMFFormsSWTLayoutUtil.class);
            BundleContext bundleContext = bundle.getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSWTLayoutOptimizer.class);
            layoutOptimizer = serviceReference != null ? (EMFFormsSWTLayoutOptimizer)bundleContext.getService(serviceReference) : new EMFFormsSWTLayoutDelayed();
        }
        return layoutOptimizer;
    }

    public static void adjustParentSize(Control control) {
        if (control.isDisposed()) {
            return;
        }
        Composite parent = control.getParent();
        while (parent != null) {
            if (ScrolledComposite.class.isInstance(parent)) {
                ScrolledComposite scrolledComposite = (ScrolledComposite)ScrolledComposite.class.cast(parent);
                Control content = scrolledComposite.getContent();
                if (content == null) {
                    return;
                }
                Point point = content.computeSize(-1, -1);
                scrolledComposite.setMinSize(point);
            } else if (ExpandBar.class.isInstance(parent)) {
                ExpandBar bar = (ExpandBar)ExpandBar.class.cast(parent);
                int oldBarHeight = 0;
                int barHeight = 0;
                ExpandItem[] expandItemArray = bar.getItems();
                int n = expandItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExpandItem item = expandItemArray[n2];
                    Control itemControl = item.getControl();
                    if (itemControl != null) {
                        oldBarHeight += item.getHeight();
                        int height = itemControl.computeSize((int)bar.getSize().x, (int)-1, (boolean)true).y;
                        barHeight += height;
                        item.setHeight(height);
                    }
                    ++n2;
                }
                if (bar.getItemCount() > 0) {
                    EMFFormsSWTLayoutUtil.updateLayoutData(bar.getLayoutData(), oldBarHeight, barHeight);
                }
            }
            if (parent.getParent() == null) {
                EMFFormsSWTLayoutUtil.getLayoutOptimizer().layout(parent);
            } else if (Shell.class.isInstance(parent)) {
                EMFFormsSWTLayoutUtil.getLayoutOptimizer().layout(parent);
            }
            parent = parent.getParent();
        }
    }

    private static void updateLayoutData(Object layoutData, int oldHeight, int newHeight) {
        if (layoutData instanceof GridData) {
            int heightHint;
            GridData gridData = (GridData)layoutData;
            if (gridData.heightHint == -1) {
                return;
            }
            gridData.heightHint = heightHint = gridData.heightHint - oldHeight + newHeight;
        }
    }
}

