/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.stack.ui.swt;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackItem;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackLayout;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackPackage;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.view.RootDomainModelChangeListener;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SWTStackLayoutRenderer
extends AbstractSWTRenderer<VStackLayout>
implements RootDomainModelChangeListener {
    private static final String CONTROL_STACK_COMPOSITE = "org_eclipse_emf_ecp_ui_layout_stack";
    private SWTGridDescription gridDescription;
    private ModelChangeListener listener;
    private Map<VStackItem, Composite> itemToCompositeMap;
    private StackLayout stackLayout;
    private Composite stackComposite;

    @Inject
    public SWTStackLayoutRenderer(VStackLayout vElement, ViewModelContext viewContext, ReportService reportService) {
        super((VElement)vElement, viewContext, reportService);
        viewContext.registerRootDomainModelChangeListener((RootDomainModelChangeListener)this);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.gridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getColumn() != 0) {
            return null;
        }
        this.stackComposite = new Composite(parent, 0);
        this.stackComposite.setBackground(parent.getBackground());
        this.stackComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)CONTROL_STACK_COMPOSITE);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        LinkedHashMap<VStackItem, AbstractSWTRenderer> elementRendererMap = new LinkedHashMap<VStackItem, AbstractSWTRenderer>();
        for (VStackItem item : ((VStackLayout)this.getVElement()).getStackItems()) {
            AbstractSWTRenderer renderer;
            try {
                renderer = ((EMFFormsRendererFactory)this.getViewModelContext().getService(EMFFormsRendererFactory.class)).getRendererInstance((VElement)item, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.stack.ui.swt", String.format(LocalizationServiceHelper.getString(SWTStackLayoutRenderer.class, (String)"SWTStackLayoutRenderer_NoRendererForItemCompositeFound"), new Object[]{item.eClass().getName(), ex}))));
                continue;
            }
            elementRendererMap.put(item, renderer);
        }
        for (Map.Entry entry : elementRendererMap.entrySet()) {
            VStackItem stackItem = (VStackItem)entry.getKey();
            AbstractSWTRenderer renderer = (AbstractSWTRenderer)entry.getValue();
            Composite itemComposite = new Composite(this.stackComposite, 0);
            itemComposite.setBackground(parent.getBackground());
            SWTGridDescription elementGridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            itemComposite.setLayoutData(LayoutProviderHelper.getSpanningLayoutData((int)1, (int)1));
            itemComposite.setLayout(LayoutProviderHelper.getColumnLayout((int)elementGridDescription.getColumns(), (boolean)false));
            for (SWTGridCell currentCell : elementGridDescription.getGrid()) {
                Control control = ((AbstractSWTRenderer)currentCell.getRenderer()).render(currentCell, itemComposite);
                if (control == null) continue;
                control.setLayoutData(LayoutProviderHelper.getLayoutData((SWTGridCell)currentCell, (SWTGridDescription)elementGridDescription, (SWTGridDescription)elementGridDescription, (SWTGridDescription)elementGridDescription, (VElement)((AbstractSWTRenderer)currentCell.getRenderer()).getVElement(), (EObject)this.getViewModelContext().getDomainModel(), (Control)control));
            }
            for (SWTGridCell currentCell : elementGridDescription.getGrid()) {
                ((AbstractSWTRenderer)currentCell.getRenderer()).finalizeRendering(itemComposite);
            }
            this.itemToCompositeMap.put(stackItem, itemComposite);
        }
        Composite nullComposite = new Composite(this.stackComposite, 0);
        this.itemToCompositeMap.put(null, nullComposite);
        this.setTopElement();
        return this.stackComposite;
    }

    private void setTopElement() {
        VStackItem topElement = ((VStackLayout)this.getVElement()).getTopElement();
        Composite composite = this.itemToCompositeMap.get(topElement);
        if (composite == null) {
            return;
        }
        this.stackLayout.topControl = composite;
        this.stackComposite.layout();
    }

    protected void preInit() {
        super.preInit();
        this.listener = new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getRawNotification().isTouch()) {
                    return;
                }
                if (notification.getNotifier() != SWTStackLayoutRenderer.this.getVElement()) {
                    return;
                }
                if (notification.getStructuralFeature() == VStackPackage.eINSTANCE.getStackLayout_TopElement()) {
                    SWTStackLayoutRenderer.this.setTopElement();
                }
            }
        };
        this.itemToCompositeMap = new LinkedHashMap<VStackItem, Composite>();
    }

    protected void postInit() {
        super.postInit();
        this.setTopElement();
        this.getViewModelContext().registerViewChangeListener(this.listener);
    }

    protected void dispose() {
        this.getViewModelContext().unregisterViewChangeListener(this.listener);
        this.gridDescription = null;
        this.listener = null;
        this.itemToCompositeMap.clear();
        this.itemToCompositeMap = null;
        this.stackLayout = null;
        this.stackComposite = null;
        super.dispose();
    }

    public void notifyChange() {
        this.setTopElement();
    }
}

