/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.history.reconstruction.CompositeReconstructorBase;
import org.eclipse.emf.edapt.history.reconstruction.FinishedException;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.internal.common.MetamodelExtent;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.InitializerChange;
import org.eclipse.emf.edapt.spi.history.MigrateableChange;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.PrimitiveChange;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.ValueChange;

public class BackwardReconstructorBase
extends CompositeReconstructorBase {
    private EObject target;
    private boolean before;

    @Override
    protected void doReconstruct(EObject target, History originalHistory, boolean before) {
        this.init(originalHistory);
        this.init(this.mapping, this.extent);
        this.target = target;
        this.before = before;
        this.endHistory(originalHistory);
        try {
            EList<Release> releases = originalHistory.getReleases();
            int i = releases.size() - 1;
            while (i >= 0) {
                Release release = (Release)releases.get(i);
                this.doReconstruct(release);
                --i;
            }
        }
        catch (FinishedException finishedException) {
            // empty catch block
        }
        this.startHistory(originalHistory);
    }

    private void init(History originalHistory) {
        this.mapping = new Mapping();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Collection rootPackages = copier.copyAll(originalHistory.getRootPackages());
        copier.copyReferences();
        for (Map.Entry entry : copier.entrySet()) {
            this.mapping.map((EObject)entry.getKey(), (EObject)entry.getValue());
        }
        this.extent = new MetamodelExtent(rootPackages);
    }

    private void doReconstruct(Release originalRelease) {
        if (!this.before && originalRelease == this.target) {
            throw new FinishedException();
        }
        this.endRelease(originalRelease);
        EList<Change> changes = originalRelease.getChanges();
        int i = changes.size() - 1;
        while (i >= 0) {
            Change change = (Change)changes.get(i);
            this.doReconstruct(change);
            --i;
        }
        this.startRelease(originalRelease);
        if (this.before && originalRelease == this.target) {
            throw new FinishedException();
        }
    }

    private void doReconstruct(Change originalChange) {
        if (!this.before && originalChange == this.target) {
            throw new FinishedException();
        }
        this.endChange(originalChange);
        if (originalChange instanceof CompositeChange) {
            CompositeChange compositeChange = (CompositeChange)originalChange;
            EList<PrimitiveChange> changes = compositeChange.getChanges();
            int i = changes.size() - 1;
            while (i >= 0) {
                Change change = (Change)changes.get(i);
                this.doReconstruct(change);
                --i;
            }
        } else if (originalChange instanceof MigrationChange) {
            MigrationChange migrationChange = (MigrationChange)originalChange;
            EList<MigrateableChange> changes = migrationChange.getChanges();
            int i = changes.size() - 1;
            while (i >= 0) {
                Change change = (Change)changes.get(i);
                this.doReconstruct(change);
                --i;
            }
        } else if (originalChange instanceof InitializerChange) {
            InitializerChange create = (InitializerChange)originalChange;
            EList<ValueChange> changes = create.getChanges();
            int i = changes.size() - 1;
            while (i >= 0) {
                ValueChange change = (ValueChange)changes.get(i);
                this.doReconstruct(change);
                --i;
            }
        }
        this.startChange(originalChange);
        if (this.before && originalChange == this.target) {
            throw new FinishedException();
        }
    }
}

