/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.ide.preferences;

import org.eclipse.emfforms.internal.ide.preferences.Messages;
import org.eclipse.emfforms.spi.ide.preferences.EmfFormsPreferences;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EmfFormsMainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button legacyButton;
    private Button segmentsButton;

    public EmfFormsMainPreferencePage() {
    }

    public EmfFormsMainPreferencePage(String title) {
        super(title);
    }

    public EmfFormsMainPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Group modeGroup = new Group(composite, 32);
        modeGroup.setText(Messages.EmfFormsMainPreferencePage_toolingModeTitle);
        Composite padding = new Composite((Composite)modeGroup, 0);
        Label modeDescription = new Label(padding, 64);
        modeDescription.setText(Messages.EmfFormsMainPreferencePage_toolingModeDescription);
        Composite modeSelection = new Composite(padding, 0);
        modeSelection.setLayout((Layout)new RowLayout(512));
        this.legacyButton = new Button(modeSelection, 16);
        this.legacyButton.setText(Messages.EmfFormsMainPreferencePage_legacyMode);
        this.segmentsButton = new Button(modeSelection, 16);
        this.segmentsButton.setText(Messages.EmfFormsMainPreferencePage_segmentMode);
        GridLayoutFactory.fillDefaults().generateLayout(modeSelection);
        GridLayoutFactory.fillDefaults().generateLayout(padding);
        GridLayoutFactory.fillDefaults().margins(5, 5).generateLayout((Composite)modeGroup);
        GridLayoutFactory.fillDefaults().generateLayout(composite);
        this.updateToolingModeButtons(EmfFormsPreferences.isSegmentTooling());
        return composite;
    }

    protected void performDefaults() {
        this.updateToolingModeButtons(false);
        super.performDefaults();
    }

    private void updateToolingModeButtons(boolean segmentTooling) {
        this.legacyButton.setSelection(!segmentTooling);
        this.segmentsButton.setSelection(segmentTooling);
    }

    public boolean performOk() {
        EmfFormsPreferences.setSegmentTooling(this.segmentsButton.getSelection());
        return super.performOk();
    }
}

