/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.spi.history.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edapt.declaration.Operation;
import org.eclipse.emf.edapt.declaration.Parameter;
import org.eclipse.emf.edapt.spi.history.HistoryFactory;
import org.eclipse.emf.edapt.spi.history.HistoryPackage;
import org.eclipse.emf.edapt.spi.history.ModelReference;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.emf.edapt.spi.history.ParameterInstance;
import org.eclipse.emf.edapt.spi.history.impl.NamedElementImpl;

public class ParameterInstanceImpl
extends NamedElementImpl
implements ParameterInstance {
    protected static final Object VALUE_EDEFAULT = null;
    protected EList<String> dataValue;
    protected EList<ModelReference> referenceValue;

    protected ParameterInstanceImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return HistoryPackage.Literals.PARAMETER_INSTANCE;
    }

    @Override
    public Object getValue() {
        Parameter parameter = this.getParameter();
        EClassifier classifier = parameter.getClassifier();
        if (parameter.isMany()) {
            if (classifier instanceof EClass) {
                ArrayList<EObject> result = new ArrayList<EObject>();
                for (ModelReference reference : this.getReferenceValue()) {
                    result.add(reference.getElement());
                }
                return result;
            }
            EDataType dataType = (EDataType)classifier;
            EList<String> dataValue = this.getDataValue();
            ArrayList<Object> result = new ArrayList<Object>();
            for (String stringValue : dataValue) {
                result.add(EcoreUtil.createFromString((EDataType)dataType, (String)stringValue));
            }
            return result;
        }
        if (classifier instanceof EClass) {
            EList<ModelReference> referenceValue = this.getReferenceValue();
            if (referenceValue.isEmpty()) {
                return null;
            }
            ModelReference reference = (ModelReference)referenceValue.get(0);
            return reference.getElement();
        }
        EDataType dataType = (EDataType)classifier;
        EList<String> dataValue = this.getDataValue();
        if (dataValue.isEmpty()) {
            return null;
        }
        String stringValue = (String)dataValue.get(0);
        return EcoreUtil.createFromString((EDataType)dataType, (String)stringValue);
    }

    @Override
    public void setValue(Object newValue) {
        Parameter parameter = this.getParameter();
        if (parameter.isMany()) {
            if (parameter.getClassifier() instanceof EClass) {
                EList<ModelReference> referenceValue = this.getReferenceValue();
                referenceValue.clear();
                Collection newReferenceValue = (Collection)newValue;
                if (newReferenceValue != null) {
                    for (EObject element : newReferenceValue) {
                        ModelReference reference = HistoryFactory.eINSTANCE.createModelReference();
                        reference.setElement(element);
                        referenceValue.add(reference);
                    }
                }
            } else {
                EDataType dataType = (EDataType)parameter.getClassifier();
                EList<String> dataValue = this.getDataValue();
                dataValue.clear();
                Collection newDataValue = (Collection)newValue;
                Iterator i = newDataValue.iterator();
                while (i.hasNext()) {
                    dataValue.add(EcoreUtil.convertToString((EDataType)dataType, i.next()));
                }
            }
        } else if (parameter.getClassifier() instanceof EClass) {
            EList<ModelReference> referenceValue = this.getReferenceValue();
            referenceValue.clear();
            if (newValue != null) {
                ModelReference reference = HistoryFactory.eINSTANCE.createModelReference();
                reference.setElement((EObject)newValue);
                referenceValue.add(reference);
            }
        } else {
            EDataType dataType = (EDataType)parameter.getClassifier();
            EList<String> dataValue = this.getDataValue();
            dataValue.clear();
            String stringValue = EcoreUtil.convertToString((EDataType)dataType, (Object)newValue);
            dataValue.add(stringValue);
        }
    }

    @Override
    public EList<String> getDataValue() {
        if (this.dataValue == null) {
            this.dataValue = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 2);
        }
        return this.dataValue;
    }

    @Override
    public EList<ModelReference> getReferenceValue() {
        if (this.referenceValue == null) {
            this.referenceValue = new EObjectContainmentEList(ModelReference.class, (InternalEObject)this, 3);
        }
        return this.referenceValue;
    }

    @Override
    public Parameter getParameter() {
        OperationInstance operationInstance = (OperationInstance)this.eContainer();
        Operation operation = operationInstance.getOperation();
        return operation.getParameter(this.getName());
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getReferenceValue()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getValue();
            }
            case 2: {
                return this.getDataValue();
            }
            case 3: {
                return this.getReferenceValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setValue(newValue);
                return;
            }
            case 2: {
                this.getDataValue().clear();
                this.getDataValue().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getReferenceValue().clear();
                this.getReferenceValue().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 2: {
                this.getDataValue().clear();
                return;
            }
            case 3: {
                this.getReferenceValue().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return VALUE_EDEFAULT == null ? this.getValue() != null : !VALUE_EDEFAULT.equals(this.getValue());
            }
            case 2: {
                return this.dataValue != null && !this.dataValue.isEmpty();
            }
            case 3: {
                return this.referenceValue != null && !this.referenceValue.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dataValue: ");
        result.append(this.dataValue);
        result.append(')');
        return result.toString();
    }
}

