/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.featurepath;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.core.services.databinding.SegmentConverterListResultImpl;
import org.eclipse.emfforms.internal.core.services.databinding.SegmentConverterValueResultImpl;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceSegmentConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterListResultEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterValueResultEMF;
import org.osgi.service.component.annotations.Component;

@Component(name="FeatureSegmentConverter")
public class FeatureSegmentConverter
implements DomainModelReferenceSegmentConverterEMF {
    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (VFeatureDomainModelReferenceSegment.class.isInstance(segment)) {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public SegmentConverterValueResultEMF convertToValueProperty(VDomainModelReferenceSegment segment, EClass segmentRoot, EditingDomain editingDomain) throws DatabindingFailedException {
        VFeatureDomainModelReferenceSegment featureSegment = this.checkAndConvertSegment(segment);
        EStructuralFeature structuralFeature = this.findStructuralFeature(segmentRoot, featureSegment);
        IEMFEditValueProperty valueProperty = EMFEditProperties.value((EditingDomain)editingDomain, (EStructuralFeature)structuralFeature);
        if (EReference.class.isInstance(structuralFeature)) {
            return new SegmentConverterValueResultImpl((IEMFValueProperty)valueProperty, ((EReference)structuralFeature).getEReferenceType());
        }
        return new SegmentConverterValueResultImpl((IEMFValueProperty)valueProperty, null);
    }

    public SegmentConverterListResultEMF convertToListProperty(VDomainModelReferenceSegment segment, EClass segmentRoot, EditingDomain editingDomain) throws DatabindingFailedException {
        VFeatureDomainModelReferenceSegment featureSegment = this.checkAndConvertSegment(segment);
        EStructuralFeature structuralFeature = this.findStructuralFeature(segmentRoot, featureSegment);
        IEMFEditListProperty listProperty = EMFEditProperties.list((EditingDomain)editingDomain, (EStructuralFeature)structuralFeature);
        if (EReference.class.isInstance(structuralFeature)) {
            return new SegmentConverterListResultImpl((IEMFListProperty)listProperty, ((EReference)structuralFeature).getEReferenceType());
        }
        return new SegmentConverterListResultImpl((IEMFListProperty)listProperty, null);
    }

    public EStructuralFeature.Setting getSetting(VDomainModelReferenceSegment segment, EObject eObject) throws DatabindingFailedException {
        VFeatureDomainModelReferenceSegment featureSegment = this.checkAndConvertSegment(segment);
        EStructuralFeature structuralFeature = eObject.eClass().getEStructuralFeature(featureSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new DatabindingFailedException(String.format("The given EOject does not contain the segment's feature. The segment was %1$s. The EObject was %2$s.", segment, eObject));
        }
        if (structuralFeature.getEType() == null) {
            throw new DatabindingFailedException(String.format("The eType of the feature %1$s is null.", structuralFeature.getName()));
        }
        return ((InternalEObject)InternalEObject.class.cast(eObject)).eSetting(structuralFeature);
    }

    private EStructuralFeature findStructuralFeature(EClass segmentRoot, VFeatureDomainModelReferenceSegment segment) throws DatabindingFailedException {
        String featureName = segment.getDomainModelFeature();
        EStructuralFeature structuralFeature = segmentRoot.getEStructuralFeature(featureName);
        if (structuralFeature == null) {
            Optional<EStructuralFeature> feature = EMFUtils.getSubClasses((EClass)segmentRoot).stream().map(c -> c.getEStructuralFeature(featureName)).filter(Objects::nonNull).findFirst();
            structuralFeature = feature.orElseThrow(() -> new DatabindingFailedException(String.format("The segment's feature could not be resolved for the given EClass. The segment was %1$s. The EClass was %2$s.", segment, segmentRoot)));
        }
        return structuralFeature;
    }

    private VFeatureDomainModelReferenceSegment checkAndConvertSegment(VDomainModelReferenceSegment segment) throws DatabindingFailedException {
        Assert.create((Object)segment).notNull();
        Assert.create((Object)segment).ofClass(VFeatureDomainModelReferenceSegment.class);
        VFeatureDomainModelReferenceSegment featureSegment = (VFeatureDomainModelReferenceSegment)segment;
        if (featureSegment.getDomainModelFeature() == null) {
            throw new DatabindingFailedException("The segment's domain model feature must not be null.");
        }
        if (featureSegment.getDomainModelFeature().isEmpty()) {
            throw new DatabindingFailedException("The segment's domain model feature must not be an empty string.");
        }
        return featureSegment;
    }
}

