/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.ui.wizard;

import java.io.File;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecp.emf2web.controller.xtend.GenerationInfo;
import org.eclipse.emf.ecp.emf2web.ui.messages.Messages;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectLocationPage
extends WizardPage {
    private DataBindingContext bindingContext;
    private final GenerationInfo generationInfo;
    private Text locationText;
    private Text generatedText;
    private Button btnWrap;
    private ControlDecoration requiredLocationDecoration;
    private boolean wasAlreadyVisible;

    public SelectLocationPage(GenerationInfo generationInfo) {
        super("wizardPage");
        this.generationInfo = generationInfo;
        this.wasAlreadyVisible = false;
        this.setTitleAndDescription();
    }

    protected void setTitleAndDescription() {
        if ("Model".equals(this.generationInfo.getType())) {
            this.setTitle(Messages.getString("SelectLocationPage.Title_ModelType"));
            this.setDescription(Messages.getString("SelectLocationPage.Description_ModelType"));
        } else if ("View".equals(this.generationInfo.getType())) {
            this.setTitle(Messages.getString("SelectLocationPage.Title_ViewType"));
            this.setDescription(Messages.getString("SelectLocationPage.Description_ViewType"));
        } else if ("Model and View".equals(this.generationInfo.getType())) {
            this.setTitle(Messages.getString("SelectLocationPage.Title_ModelAndViewType"));
            this.setDescription(Messages.getString("SelectLocationPage.Description_ModelAndViewType"));
        } else {
            this.setTitle(String.valueOf(Messages.getString("SelectLocationPage.Title_OtherType")) + this.generationInfo.getNameProposal());
            this.setDescription(Messages.getString("SelectLocationPage.Description_OtherType"));
        }
    }

    public GenerationInfo getGenerationInfo() {
        return this.generationInfo;
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblLocation = new Label(container, 0);
        lblLocation.setText(Messages.getString("SelectLocationPage.LocationLabel"));
        new Label(container, 0);
        new Label(container, 0);
        this.locationText = new Text(container, 2048);
        this.locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.requiredLocationDecoration = new ControlDecoration((Control)this.locationText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.requiredLocationDecoration.setImage(fieldDecoration.getImage());
        this.requiredLocationDecoration.setDescriptionText(Messages.getString("SelectLocationPage.RequiredDecorationText"));
        this.requiredLocationDecoration.hide();
        Button browseWorkspaceButton = new Button(container, 0);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new BrowseWorkspaceButtonSelectionListener());
        browseWorkspaceButton.setText(Messages.getString("SelectLocationPage.BrowseWorkspaceButtonLabel"));
        Button browseFilesystemButton = new Button(container, 0);
        browseFilesystemButton.addSelectionListener((SelectionListener)new BrowseFilesystemButtonSelectionListener());
        browseFilesystemButton.setText(Messages.getString("SelectLocationPage.BrowseFilesystemButtonLabel"));
        new Label(container, 0);
        if (this.generationInfo.getWrapper() != null) {
            Group grpWrapper = new Group(container, 0);
            grpWrapper.setLayout((Layout)new GridLayout(1, false));
            grpWrapper.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            grpWrapper.setText(Messages.getString("SelectLocationPage.OptionalSettingsGroupText"));
            this.btnWrap = new Button((Composite)grpWrapper, 32);
            this.btnWrap.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
            String buttonText = String.valueOf(Messages.getString("SelectLocationPage.WrapButtonText")) + ' ' + this.generationInfo.getWrapper().getName();
            this.btnWrap.setText(buttonText);
        }
        Group grpPreview = new Group(container, 0);
        grpPreview.setLayout((Layout)new FillLayout(256));
        grpPreview.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        grpPreview.setText(Messages.getString("SelectLocationPage.ContentGroupText"));
        this.generatedText = new Text((Composite)grpPreview, 2818);
        this.bindingContext = this.initDataBindings();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.bindingContext);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.wasAlreadyVisible) {
            this.wasAlreadyVisible = true;
        }
    }

    public boolean wasAlreadyVisible() {
        return this.wasAlreadyVisible;
    }

    private void setNewLocation(URI location) {
        this.generationInfo.setLocation(location);
        this.bindingContext.updateTargets();
        this.requiredLocationDecoration.hide();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextLocationTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.locationText);
        IObservableValue locationGenerationInfoObserveValue = PojoProperties.value((String)"location").observe((Object)this.generationInfo);
        bindingContext.bindValue((IObservableValue)observeTextLocationTextObserveWidget, locationGenerationInfoObserveValue, new UpdateValueStrategy().setConverter((IConverter)new StringToURIConverter()).setAfterConvertValidator((IValidator)new LocationValidator()), new UpdateValueStrategy().setConverter((IConverter)new URItoStringConverter()));
        ISWTObservableValue observeTextGeneratedTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.generatedText);
        IObservableValue generatedStringGenerationInfoObserveValue = PojoProperties.value((String)"generatedString").observe((Object)this.generationInfo);
        bindingContext.bindValue((IObservableValue)observeTextGeneratedTextObserveWidget, generatedStringGenerationInfoObserveValue, null, null);
        if (this.generationInfo.getWrapper() != null) {
            ISWTObservableValue observeSelectionBtnWrapObserveWidget = WidgetProperties.buttonSelection().observe((Widget)this.btnWrap);
            IObservableValue wrapGenerationInfoObserveValue = PojoProperties.value((String)"wrap").observe((Object)this.generationInfo);
            bindingContext.bindValue((IObservableValue)observeSelectionBtnWrapObserveWidget, wrapGenerationInfoObserveValue, null, null);
        }
        return bindingContext;
    }

    private class BrowseFilesystemButtonSelectionListener
    extends SelectionAdapter {
        private BrowseFilesystemButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String result;
            FileDialog fileDialog = new FileDialog(SelectLocationPage.this.getShell(), 8196);
            if (SelectLocationPage.this.generationInfo.getLocation() != null && !SelectLocationPage.this.generationInfo.getLocation().isPlatform()) {
                File file = new File(SelectLocationPage.this.generationInfo.getLocation().toFileString());
                File parent = file.getParentFile();
                if (parent != null && parent.exists()) {
                    fileDialog.setFilterPath(parent.getAbsolutePath());
                }
                fileDialog.setFileName(file.getName());
            }
            if ((result = fileDialog.open()) != null) {
                URI newLocation = URI.createFileURI((String)result);
                SelectLocationPage.this.setNewLocation(newLocation);
            }
        }
    }

    private class BrowseWorkspaceButtonSelectionListener
    extends SelectionAdapter {
        private BrowseWorkspaceButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IWorkspaceRoot root;
            IResource resource;
            WorkspaceResourceDialog dialog = new WorkspaceResourceDialog(SelectLocationPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setAllowMultiple(false);
            dialog.setTitle(Messages.getString("SelectLocationPage.SelectLocationDialogTitle"));
            dialog.setShowNewFolderControl(true);
            dialog.setShowFileControl(true);
            if (SelectLocationPage.this.generationInfo.getLocation() != null && SelectLocationPage.this.generationInfo.getLocation().isPlatform() && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(SelectLocationPage.this.generationInfo.getLocation().trimSegments(1).toPlatformString(true))) != null && resource.isAccessible()) {
                dialog.setInitialSelection((Object)resource);
                int segment = SelectLocationPage.this.generationInfo.getLocation().segmentCount() > 0 ? SelectLocationPage.this.generationInfo.getLocation().segmentCount() - 1 : 0;
                dialog.setFileText(SelectLocationPage.this.generationInfo.getLocation().segment(segment));
            }
            dialog.loadContents();
            if (dialog.open() == 0) {
                IFile file = dialog.getFile();
                URI newLocation = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                SelectLocationPage.this.setNewLocation(newLocation);
            }
        }
    }

    private class LocationValidator
    implements IValidator {
        private LocationValidator() {
        }

        public IStatus validate(Object value) {
            if (value == null) {
                SelectLocationPage.this.requiredLocationDecoration.show();
                return ValidationStatus.error((String)Messages.getString("SelectLocationPage.LocationError"));
            }
            if (URI.class.isInstance(value)) {
                URI uri = (URI)URI.class.cast(value);
                if (uri.isPlatform()) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource resource = root.findMember(uri.toPlatformString(true));
                    if (IContainer.class.isInstance(resource)) {
                        SelectLocationPage.this.requiredLocationDecoration.show();
                        return ValidationStatus.error((String)Messages.getString("SelectLocationPage.LocationDirectoryError"));
                    }
                } else {
                    if (uri.toFileString() == null) {
                        SelectLocationPage.this.requiredLocationDecoration.show();
                        return ValidationStatus.error((String)Messages.getString("SelectLocationPage.LocationValidError"));
                    }
                    File file = new File(uri.toFileString());
                    if (file.isDirectory()) {
                        SelectLocationPage.this.requiredLocationDecoration.show();
                        return ValidationStatus.error((String)Messages.getString("SelectLocationPage.LocationDirectoryError"));
                    }
                }
            }
            SelectLocationPage.this.requiredLocationDecoration.hide();
            return ValidationStatus.ok();
        }
    }

    private class StringToURIConverter
    implements IConverter {
        private StringToURIConverter() {
        }

        public Object getToType() {
            return URI.class;
        }

        public Object getFromType() {
            return String.class;
        }

        public Object convert(Object fromObject) {
            if (fromObject == null || "".equals(fromObject)) {
                return null;
            }
            String path = (String)fromObject;
            if (path.startsWith("platform:") || path.startsWith("file:")) {
                return URI.createURI((String)path, (boolean)false);
            }
            return URI.createFileURI((String)path);
        }
    }

    private class URItoStringConverter
    implements IConverter {
        private URItoStringConverter() {
        }

        public Object getToType() {
            return String.class;
        }

        public Object getFromType() {
            return URI.class;
        }

        public Object convert(Object fromObject) {
            if (fromObject == null) {
                return "";
            }
            URI path = (URI)fromObject;
            if (path.isFile()) {
                return path.toFileString();
            }
            return path.toString();
        }
    }
}

