/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.index;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.internal.core.services.segments.featurepath.FeatureDmrToRootEClassConverter;
import org.eclipse.emfforms.spi.core.services.segments.DmrToRootEClassConverter;
import org.eclipse.emfforms.spi.core.services.segments.LegacyDmrToRootEClass;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(name="IndexDmrToRootEClassConverter", service={DmrToRootEClassConverter.class})
public class IndexDmrToRootEClassConverter
extends FeatureDmrToRootEClassConverter {
    private LegacyDmrToRootEClass dmrToRootEClass;
    private ServiceReference<LegacyDmrToRootEClass> dmrToRootEClassServiceRef;

    public double isApplicable(VDomainModelReference dmr) {
        if (dmr instanceof VIndexDomainModelReference) {
            return 3.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public EClass getRootEClass(VDomainModelReference dmr) {
        VIndexDomainModelReference indexDmr = (VIndexDomainModelReference)dmr;
        if (indexDmr.getPrefixDMR() == null) {
            return super.getRootEClass(dmr);
        }
        return (EClass)this.getLegacyDmrToRootEClass().getRootEClass(indexDmr.getPrefixDMR()).orElseThrow(() -> new IllegalArgumentException("Could not determine root EClass of the index dmrs prefix dmr: " + indexDmr.getPrefixDMR()));
    }

    @Deactivate
    public void dispose() {
        this.dmrToRootEClass = null;
        if (this.dmrToRootEClassServiceRef != null) {
            FrameworkUtil.getBundle(IndexDmrToRootEClassConverter.class).getBundleContext().ungetService(this.dmrToRootEClassServiceRef);
            this.dmrToRootEClassServiceRef = null;
        }
    }

    private LegacyDmrToRootEClass getLegacyDmrToRootEClass() {
        if (this.dmrToRootEClass == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(IndexDmrToRootEClassConverter.class).getBundleContext();
            this.dmrToRootEClassServiceRef = bundleContext.getServiceReference(LegacyDmrToRootEClass.class);
            this.dmrToRootEClass = (LegacyDmrToRootEClass)bundleContext.getService(this.dmrToRootEClassServiceRef);
        }
        return this.dmrToRootEClass;
    }

    void setLegacyDmrToRootEClass(LegacyDmrToRootEClass dmrToRootEClass) {
        this.dmrToRootEClass = dmrToRootEClass;
    }
}

