/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.ui.search;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.emfstore.ui.search.Messages;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.ui.util.ECPHandlerHelper;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class SearchModelElementHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] selections;
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        InternalProject project = (InternalProject)ECPUtil.getECPProjectManager().getProject(selection.getFirstElement());
        if (project == null) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.SearchModelElementHandler_Information, (String)Messages.SearchModelElementHandler_YouMustSelectProject);
            return null;
        }
        InternalProvider internalProvider = project.getProvider();
        if (internalProvider == null) {
            return null;
        }
        if (!"org.eclipse.emf.ecp.emfstore.provider".equals((internalProvider = (InternalProvider)ECPUtil.getResolvedElement((ECPElement)internalProvider)).getName())) {
            return null;
        }
        ESLocalProject projectSpace = ((EMFStoreProvider)internalProvider).getProjectSpace(project);
        if (projectSpace == null) {
            return null;
        }
        Set eObjects = projectSpace.getAllModelElements();
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (ILabelProvider)adapterFactoryLabelProvider);
        dialog.setElements(eObjects.toArray());
        dialog.setMultipleSelection(false);
        dialog.setMessage(Messages.SearchModelElementHandler_EnterModelName);
        dialog.setTitle(Messages.SearchModelElementHandler_SearchModelElement);
        if (dialog.open() == 0 && (selections = dialog.getResult()) != null && selections.length == 1 && selections[0] instanceof EObject) {
            ECPHandlerHelper.openModelElement((Object)selections[0], (ECPProject)project);
        }
        adapterFactoryLabelProvider.dispose();
        composedAdapterFactory.dispose();
        return null;
    }
}

