/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.mapping;

import java.util.Optional;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRSegmentExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.eclipse.emfforms.spi.view.mappingsegment.model.VMappingDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="MappingSegmentExpander")
public class MappingSegmentExpander
implements EMFFormsDMRSegmentExpander {
    private static final String VALUE = "value";
    private static final String KEY = "key";
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (segment == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain model reference segment was null."));
            return NOT_APPLICABLE;
        }
        if (VMappingDomainModelReferenceSegment.class.isInstance(segment)) {
            return 5.0;
        }
        return NOT_APPLICABLE;
    }

    public Optional<EObject> prepareDomainObject(VDomainModelReferenceSegment segment, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)segment).notNull().ofClass(VMappingDomainModelReferenceSegment.class);
        Assert.create((Object)domainObject).notNull();
        VMappingDomainModelReferenceSegment mappingSegment = (VMappingDomainModelReferenceSegment)segment;
        EStructuralFeature structuralFeature = domainObject.eClass().getEStructuralFeature(mappingSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new EMFFormsExpandingFailedException(String.format("The given domain object does not contain the segment's feature. The segment was %1$s. The domain object was %2$s.", segment, domainObject));
        }
        this.checkMapType(structuralFeature);
        EClass eClass = (EClass)structuralFeature.getEType();
        EReference valueReference = (EReference)eClass.getEStructuralFeature(VALUE);
        EMap map = (EMap)domainObject.eGet(structuralFeature);
        EClass mappedClass = mappingSegment.getMappedClass();
        if (map.get((Object)mappedClass) == null) {
            EObject newElement = this.instantiateMappedObject(mappingSegment, valueReference);
            map.put((Object)mappedClass, (Object)newElement);
        }
        return Optional.ofNullable((EObject)map.get((Object)mappedClass));
    }

    private EObject instantiateMappedObject(VMappingDomainModelReferenceSegment segment, EReference reference) throws EMFFormsExpandingFailedException {
        EClass eClass = reference.getEReferenceType().isSuperTypeOf(segment.getMappedClass()) ? segment.getMappedClass() : reference.getEReferenceType();
        if (eClass.isAbstract() || eClass.isInterface()) {
            throw new EMFFormsExpandingFailedException(String.format("The reference type of the segment's map's value feature is either abstract or an interface. Therefore, no instance can be created. The segment was %1$s.", segment));
        }
        return EcoreUtil.create((EClass)eClass);
    }

    private void checkMapType(EStructuralFeature structuralFeature) throws EMFFormsExpandingFailedException {
        this.checkStructuralFeature(structuralFeature);
        EClass eClass = (EClass)structuralFeature.getEType();
        EStructuralFeature keyFeature = eClass.getEStructuralFeature(KEY);
        EStructuralFeature valueFeature = eClass.getEStructuralFeature(VALUE);
        if (keyFeature == null || valueFeature == null) {
            throw new EMFFormsExpandingFailedException("The segment's structural feature must reference a map.");
        }
        if (!EReference.class.isInstance(keyFeature)) {
            throw new EMFFormsExpandingFailedException("The keys of the map referenced by the segment's structural feature must be referenced EClasses.");
        }
        if (!EReference.class.isInstance(valueFeature)) {
            throw new EMFFormsExpandingFailedException("The values of the map referenced by the segment's structural feature must be referenced EObjects.");
        }
        if (!EClass.class.isAssignableFrom(((EReference)keyFeature).getEReferenceType().getInstanceClass())) {
            throw new EMFFormsExpandingFailedException("The keys of the map referenced by the segment's structural feature must be referenced EClasses.");
        }
    }

    private void checkStructuralFeature(EStructuralFeature structuralFeature) throws EMFFormsExpandingFailedException {
        if (structuralFeature.getEType() == null) {
            throw new EMFFormsExpandingFailedException("The EType of the segment's structural feature was null.");
        }
        if (structuralFeature.getEType().getInstanceClassName() == null) {
            throw new EMFFormsExpandingFailedException("The InstanceClassName of the segment's structural feature's EType was null.");
        }
        if (!structuralFeature.getEType().getInstanceClassName().equals("java.util.Map$Entry")) {
            throw new EMFFormsExpandingFailedException("The segment's structural feature must reference a map.");
        }
        if (structuralFeature.getLowerBound() != 0 || structuralFeature.getUpperBound() != -1) {
            throw new EMFFormsExpandingFailedException("The segment's structural feature must reference a map.");
        }
    }

    public boolean needsToExpandLastSegment() {
        return false;
    }
}

