/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.Collections;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.ui.view.swt.reference.OpenInNewContextStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceServiceCustomizationVendor;
import org.eclipse.emf.ecp.view.internal.editor.handler.CreateSegmentDmrWizard;
import org.eclipse.emf.ecp.view.internal.editor.handler.FeatureSegmentGenerator;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.spi.ide.view.segments.ToolingModeUtil;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;

@Component(name="DmrOpenInNewContextStrategyProvider", property={"service.ranking:Integer=20"})
public class DmrOpenInNewContextStrategyProvider
extends ReferenceServiceCustomizationVendor<OpenInNewContextStrategy>
implements OpenInNewContextStrategy.Provider {
    protected boolean handles(EObject owner, EReference reference) {
        if (!ToolingModeUtil.isSegmentToolingEnabled()) {
            return false;
        }
        return reference.getEReferenceType() == VViewPackage.Literals.DOMAIN_MODEL_REFERENCE;
    }

    @Create
    public OpenInNewContextStrategy createOpenInNewContextStrategy() {
        return (owner, reference, object) -> {
            EClass viewRoot = Helper.getRootEClass(owner);
            VDomainModelReference dmr = (VDomainModelReference)object;
            CreateSegmentDmrWizard dmrWizard = new CreateSegmentDmrWizard(viewRoot, "Edit Domain Model Reference", dmr, structuralFeature -> null, new FeatureSegmentGenerator(), null, false);
            WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)dmrWizard);
            wizardDialog.setBlockOnOpen(true);
            wizardDialog.open();
            Optional<VDomainModelReference> newDmr = dmrWizard.getDomainModelReference();
            if (newDmr.isPresent()) {
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)owner);
                Command command = reference.isMany() ? ReplaceCommand.create((EditingDomain)domain, (Object)owner, (Object)reference, (Object)object, Collections.singleton(newDmr.get())) : SetCommand.create((EditingDomain)domain, (Object)owner, (Object)reference, (Object)newDmr.get());
                domain.getCommandStack().execute(command);
            }
            return true;
        };
    }
}

