/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.core;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends Plugin {
    private static final String NULL = "NULL";
    public static final String PLUGIN_ID = "org.eclipse.emfforms.swt.core";
    private static Activator plugin;
    private final Map<String, Image> imageRegistry = new LinkedHashMap<String, Image>(20, 0.8f, true){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean removeEldestEntry(Map.Entry<String, Image> eldest) {
            return this.size() > 20;
        }

        @Override
        public Image remove(Object arg0) {
            Image image = (Image)super.remove(arg0);
            image.dispose();
            return image;
        }
    };
    private ServiceReference<VTViewTemplateProvider> viewTemplateReference;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.imageRegistry.values().forEach(Resource::dispose);
        if (this.viewTemplateReference != null) {
            context.ungetService(this.viewTemplateReference);
        }
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static Image getImage(URL url) {
        if (!Activator.getDefault().imageRegistry.containsKey(url == null ? NULL : url.toExternalForm())) {
            ImageDescriptor createFromURL = ImageDescriptor.createFromURL((URL)url);
            Activator.getDefault().imageRegistry.put(url == null ? NULL : url.toExternalForm(), createFromURL.createImage());
        }
        return Activator.getDefault().imageRegistry.get(url == null ? NULL : url.toExternalForm());
    }

    public VTViewTemplateProvider getVTViewTemplateProvider() {
        if (this.viewTemplateReference == null) {
            this.viewTemplateReference = plugin.getBundle().getBundleContext().getServiceReference(VTViewTemplateProvider.class);
        }
        if (this.viewTemplateReference != null) {
            return (VTViewTemplateProvider)plugin.getBundle().getBundleContext().getService(this.viewTemplateReference);
        }
        return null;
    }
}

