/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.renderer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.mandatory.model.VTMandatoryFactory;
import org.eclipse.emf.ecp.view.template.style.mandatory.model.VTMandatoryStyleProperty;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsAbstractSpreadsheetRenderer;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsExportTableParent;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsIdProvider;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetFormatDescriptionProvider;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRenderTarget;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsConverterException;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverter;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverterRegistry;

public class EMFFormsSpreadsheetControlRenderer
extends EMFFormsAbstractSpreadsheetRenderer<VControl> {
    private final EMFFormsDatabindingEMF emfformsDatabinding;
    private final EMFFormsLabelProvider emfformsLabelProvider;
    private final ReportService reportService;
    private final VTViewTemplateProvider vtViewTemplateProvider;
    private final EMFFormsIdProvider idProvider;
    private final EMFFormsSpreadsheetValueConverterRegistry converterRegistry;
    private final EMFFormsSpreadsheetFormatDescriptionProvider formatDescriptionProvider;
    private final EMFFormsDomainExpander domainExpander;

    public EMFFormsSpreadsheetControlRenderer(EMFFormsDatabindingEMF emfformsDatabinding, EMFFormsLabelProvider emfformsLabelProvider, ReportService reportService, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsIdProvider idProvider, EMFFormsSpreadsheetValueConverterRegistry converterRegistry, EMFFormsSpreadsheetFormatDescriptionProvider formatDescriptionProvider, EMFFormsDomainExpander domainExpander) {
        this.emfformsDatabinding = emfformsDatabinding;
        this.emfformsLabelProvider = emfformsLabelProvider;
        this.reportService = reportService;
        this.vtViewTemplateProvider = vtViewTemplateProvider;
        this.idProvider = idProvider;
        this.converterRegistry = converterRegistry;
        this.formatDescriptionProvider = formatDescriptionProvider;
        this.domainExpander = domainExpander;
    }

    public int render(Workbook workbook, VControl vElement, ViewModelContext viewModelContext, EMFFormsSpreadsheetRenderTarget renderTarget) {
        Row formatRow;
        Row descriptionRow;
        Row labelRow;
        Sheet sheet = workbook.getSheet(renderTarget.getSheetName());
        if (sheet == null) {
            sheet = workbook.createSheet(renderTarget.getSheetName());
            EMFFormsSpreadsheetControlRenderer.setupSheetFormat(sheet);
        }
        if ((labelRow = sheet.getRow(0)) == null) {
            labelRow = sheet.createRow(0);
        }
        if ((descriptionRow = sheet.getRow(1)) == null) {
            descriptionRow = sheet.createRow(1);
        }
        if ((formatRow = sheet.getRow(2)) == null) {
            formatRow = sheet.createRow(2);
        }
        CellStyle readOnly = (CellStyle)viewModelContext.getContextValue("CellStyle_Locked");
        CellStyle readOnlyWrap = (CellStyle)viewModelContext.getContextValue("CellStyle_LockedWrapped");
        Cell idCell = labelRow.getCell(0, Row.CREATE_NULL_AS_BLANK);
        idCell.setCellValue("EOBJECT_ID");
        idCell.setCellStyle(readOnly);
        Cell labelCell = labelRow.getCell(renderTarget.getColumn() + 1, Row.CREATE_NULL_AS_BLANK);
        labelCell.setCellStyle(readOnlyWrap);
        Cell descriptionCell = descriptionRow.getCell(renderTarget.getColumn() + 1, Row.CREATE_NULL_AS_BLANK);
        descriptionCell.setCellStyle(readOnlyWrap);
        Cell formatCell = formatRow.getCell(renderTarget.getColumn() + 1, Row.CREATE_NULL_AS_BLANK);
        formatCell.setCellStyle(readOnlyWrap);
        try {
            EMFFormsExportTableParent exportTableParent = (EMFFormsExportTableParent)viewModelContext.getContextValue("excelExportParent");
            VDomainModelReference dmrToResolve = (VDomainModelReference)EcoreUtil.copy((EObject)vElement.getDomainModelReference());
            if (exportTableParent != null) {
                VIndexDomainModelReference indexDMR = exportTableParent.getIndexDMRToExtend();
                indexDMR.setTargetDMR(dmrToResolve);
                dmrToResolve = exportTableParent.getIndexDMRToResolve();
            }
            if (labelCell.getCellComment() == null) {
                EStructuralFeature structuralFeature = this.emfformsDatabinding.getValueProperty(dmrToResolve, viewModelContext.getDomainModel()).getStructuralFeature();
                this.writeLabel(vElement, viewModelContext, labelCell, exportTableParent, dmrToResolve, structuralFeature);
                Comment comment = this.createComment(workbook, sheet, dmrToResolve, renderTarget.getRow(), renderTarget.getColumn() + 1);
                labelCell.setCellComment(comment);
                this.writeDescription(viewModelContext, descriptionCell, dmrToResolve);
                this.writeFormatInformation(formatCell, structuralFeature);
            }
            if (viewModelContext.getDomainModel() != null) {
                this.writeValue(viewModelContext, renderTarget, sheet, dmrToResolve);
            }
            return 1;
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
        }
        catch (NoLabelFoundException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
        }
        catch (IOException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
        }
        catch (EMFFormsConverterException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
        }
        return 0;
    }

    private void writeValue(ViewModelContext viewModelContext, EMFFormsSpreadsheetRenderTarget renderTarget, Sheet sheet, VDomainModelReference dmrToResolve) throws DatabindingFailedException, EMFFormsConverterException {
        Row valueRow = sheet.getRow(renderTarget.getRow() + 3);
        if (valueRow == null) {
            valueRow = sheet.createRow(renderTarget.getRow() + 3);
        }
        valueRow.getCell(0, Row.CREATE_NULL_AS_BLANK).setCellValue(this.idProvider.getId(viewModelContext.getDomainModel()));
        try {
            this.expandDMR(dmrToResolve, viewModelContext.getDomainModel());
        }
        catch (EMFFormsExpandingFailedException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
            return;
        }
        EStructuralFeature.Setting setting = this.emfformsDatabinding.getSetting(dmrToResolve, viewModelContext.getDomainModel());
        if (setting.getEObject() == null || !setting.getEStructuralFeature().isUnsettable() || setting.getEStructuralFeature().isUnsettable() && setting.isSet()) {
            Object value = setting.get(true);
            EMFFormsSpreadsheetValueConverter converter = this.converterRegistry.getConverter(viewModelContext.getDomainModel(), dmrToResolve);
            Cell valueCell = valueRow.getCell(renderTarget.getColumn() + 1, Row.CREATE_NULL_AS_BLANK);
            converter.setCellValue(valueCell, value, setting.getEStructuralFeature(), viewModelContext);
        }
    }

    private void expandDMR(VDomainModelReference dmrToResolve, EObject domainModel) throws EMFFormsExpandingFailedException {
        this.domainExpander.prepareDomainObject(dmrToResolve, domainModel);
    }

    private void writeLabel(VControl vControl, ViewModelContext viewModelContext, Cell labelCell, EMFFormsExportTableParent exportTableParent, VDomainModelReference dmrToResolve, EStructuralFeature structuralFeature) throws NoLabelFoundException {
        IObservableValue displayName = viewModelContext.getDomainModel() != null ? this.emfformsLabelProvider.getDisplayName(dmrToResolve, viewModelContext.getDomainModel()) : this.emfformsLabelProvider.getDisplayName(dmrToResolve);
        String labelValue = displayName.getValue().toString();
        if (exportTableParent != null) {
            labelValue = String.valueOf(exportTableParent.getLabelPrefix()) + "_" + labelValue;
        }
        String extra = "";
        VTMandatoryStyleProperty mandatoryStyle = this.getMandatoryStyle((VElement)vControl, viewModelContext);
        if (mandatoryStyle.isHighliteMandatoryFields() && structuralFeature.getLowerBound() > 0) {
            extra = mandatoryStyle.getMandatoryMarker();
        }
        labelValue = String.valueOf(labelValue) + extra;
        labelCell.setCellValue(labelValue);
        displayName.dispose();
    }

    private void writeDescription(ViewModelContext viewModelContext, Cell descriptionCell, VDomainModelReference dmrToResolve) throws NoLabelFoundException {
        IObservableValue description = viewModelContext.getDomainModel() != null ? this.emfformsLabelProvider.getDescription(dmrToResolve, viewModelContext.getDomainModel()) : this.emfformsLabelProvider.getDescription(dmrToResolve);
        descriptionCell.setCellValue(description.getValue().toString());
        description.dispose();
    }

    private void writeFormatInformation(Cell formatCell, EStructuralFeature structuralFeature) {
        String format = "";
        if (this.formatDescriptionProvider != null) {
            format = this.formatDescriptionProvider.getFormatDescription(structuralFeature);
        }
        formatCell.setCellValue(format);
    }

    private static void setupSheetFormat(Sheet sheet) {
        sheet.setDefaultColumnWidth(30);
        sheet.createFreezePane(1, 3);
    }

    private VTMandatoryStyleProperty getMandatoryStyle(VElement vElement, ViewModelContext viewModelContext) {
        if (this.vtViewTemplateProvider == null) {
            return this.getDefaultStyle();
        }
        Set styleProperties = this.vtViewTemplateProvider.getStyleProperties(vElement, viewModelContext);
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTMandatoryStyleProperty.class.isInstance(styleProperty)) continue;
            return (VTMandatoryStyleProperty)styleProperty;
        }
        return this.getDefaultStyle();
    }

    private VTMandatoryStyleProperty getDefaultStyle() {
        return VTMandatoryFactory.eINSTANCE.createMandatoryStyleProperty();
    }

    private Comment createComment(Workbook workbook, Sheet sheet, VDomainModelReference domainModelReference, int row, int column) throws IOException {
        CreationHelper factory = workbook.getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(column);
        anchor.setCol2(column + 1);
        anchor.setRow1(row);
        anchor.setRow2(row + 1);
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(anchor);
        comment.setAuthor("EMFForms Spreadsheet Renderer");
        comment.setVisible(false);
        comment.setString(factory.createRichTextString(this.getSerializedDMR(domainModelReference)));
        return comment;
    }

    private String getSerializedDMR(VDomainModelReference domainModelReference) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.createResource(URI.createURI((String)"VIRTAUAL_URI"));
        resource.getContents().add((Object)EcoreUtil.copy((EObject)domainModelReference));
        StringWriter sw = new StringWriter();
        URIConverter.WriteableOutputStream os = new URIConverter.WriteableOutputStream((Writer)sw, "UTF-8");
        resource.save((OutputStream)os, null);
        String value = sw.getBuffer().toString();
        return value;
    }
}

