/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core;

import java.text.MessageFormat;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.swt.core.data.EMFFormsSWTControlDataService;
import org.eclipse.emfforms.spi.swt.core.data.EMFFormsSWTDataService;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class SWTDataElementIdHelper {
    public static final String ELEMENT_ID_KEY = "org.eclipse.emfforms.elementId";
    private static final String ID_PATTERN = "{0}#{1}";
    private static final String CONTROL = "control";

    private SWTDataElementIdHelper() {
    }

    public static void setElementIdDataForVControl(Widget widget, VControl element, ViewModelContext context) {
        SWTDataElementIdHelper.setElementIdDataWithSubId(widget, (VElement)element, CONTROL, context);
    }

    public static void setElementIdDataWithSubId(Widget widget, VElement element, String subId, ViewModelContext context) {
        widget.setData(ELEMENT_ID_KEY, (Object)SWTDataElementIdHelper.getData(element, widget, SWTDataElementIdHelper.getId(element, context), subId));
    }

    private static String getData(VElement element, Widget widget, String id, String subId) {
        Bundle bundle = FrameworkUtil.getBundle(SWTDataElementIdHelper.class);
        if (bundle == null) {
            return MessageFormat.format(ID_PATTERN, id, subId);
        }
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            return MessageFormat.format(ID_PATTERN, id, subId);
        }
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSWTControlDataService.class);
        if (serviceReference == null) {
            return MessageFormat.format(ID_PATTERN, id, subId);
        }
        EMFFormsSWTControlDataService service = (EMFFormsSWTControlDataService)bundleContext.getService(serviceReference);
        if (service == null) {
            return MessageFormat.format(ID_PATTERN, id, subId);
        }
        String data = service.getData(element, widget, id, subId);
        bundleContext.ungetService(serviceReference);
        return data;
    }

    private static String getId(VElement element, ViewModelContext context) {
        Bundle bundle = FrameworkUtil.getBundle(SWTDataElementIdHelper.class);
        if (bundle == null) {
            return element.getUuid();
        }
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            return element.getUuid();
        }
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSWTDataService.class);
        if (serviceReference == null) {
            return element.getUuid();
        }
        EMFFormsSWTDataService service = (EMFFormsSWTDataService)bundleContext.getService(serviceReference);
        if (service == null) {
            return element.getUuid();
        }
        String id = service.getId(element, context);
        bundleContext.ungetService(serviceReference);
        return id;
    }
}

