/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.structuralchange.table;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emfforms.internal.core.services.structuralchange.defaultheuristic.StructuralChangeTesterDefault;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeTesterInternal;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(name="StructuralChangeTesterTable")
public class StructuralChangeTesterTable
implements StructuralChangeTesterInternal {
    private EMFFormsStructuralChangeTester emfFormsStructuralChangeTester;
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsStructuralChangeTester> emfFormsStructuralChangeTesterServiceReference;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.emfFormsStructuralChangeTesterServiceReference != null) {
            bundleContext.ungetService(this.emfFormsStructuralChangeTesterServiceReference);
            this.emfFormsStructuralChangeTester = null;
        }
    }

    private EMFFormsStructuralChangeTester getEMFFormsStructuralChangeTester() {
        if (this.emfFormsStructuralChangeTester == null) {
            this.emfFormsStructuralChangeTesterServiceReference = this.bundleContext.getServiceReference(EMFFormsStructuralChangeTester.class);
            if (this.emfFormsStructuralChangeTesterServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.emfFormsStructuralChangeTester = (EMFFormsStructuralChangeTester)this.bundleContext.getService(this.emfFormsStructuralChangeTesterServiceReference);
        }
        return this.emfFormsStructuralChangeTester;
    }

    void setEMFFormsStructuralChangeTester(EMFFormsStructuralChangeTester emfFormsStructuralChangeTester) {
        this.emfFormsStructuralChangeTester = emfFormsStructuralChangeTester;
    }

    public double isApplicable(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        if (VTableDomainModelReference.class.isInstance(reference)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean isStructureChanged(VDomainModelReference reference, EObject domainRootObject, ModelChangeNotification notification) {
        Assert.create((Object)reference).notNull();
        Assert.create((Object)notification).notNull();
        Assert.create((Object)reference).ofClass(VTableDomainModelReference.class);
        if (notification.getRawNotification().isTouch()) {
            return false;
        }
        VTableDomainModelReference tableDMR = (VTableDomainModelReference)reference;
        if (tableDMR.getDomainModelEFeature() != null) {
            StructuralChangeTesterDefault featurePathTester = new StructuralChangeTesterDefault();
            return featurePathTester.isStructureChanged(reference, domainRootObject, notification);
        }
        Assert.create((Object)tableDMR.getDomainModelReference()).notNull();
        return this.getEMFFormsStructuralChangeTester().isStructureChanged(tableDMR.getDomainModelReference(), domainRootObject, notification);
    }
}

