/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.service;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.spi.view.template.service.ViewTemplateSupplier;
import org.eclipse.emf.ecp.spi.view.template.service.ViewTemplateSupplierUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTStyle;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTStyleSelector;
import org.eclipse.emf.ecp.view.template.model.VTStyleSelectorContainer;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplate;
import org.eclipse.emf.ecp.view.template.selector.domainmodelreference.model.VTDomainModelReferenceSelector;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.segments.EMFFormsSegmentGenerator;
import org.eclipse.emfforms.spi.core.services.segments.RuntimeModeUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(name="ViewTemplateSupplierImpl")
public class ViewTemplateSupplierImpl
implements ViewTemplateSupplier {
    private static final String EXTENSION = "org.eclipse.emf.ecp.view.template";
    private Set<VTViewTemplate> registeredTemplates = new LinkedHashSet<VTViewTemplate>();
    private ReportService reportService;
    private EMFFormsSegmentGenerator segmentGenerator;

    @Reference(cardinality=ReferenceCardinality.MANDATORY, unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Reference(unbind="-")
    void setEMFFormsSegmentGenerator(EMFFormsSegmentGenerator segmentGenerator) {
        this.segmentGenerator = segmentGenerator;
    }

    @Activate
    protected void startup(BundleContext bundleContext) {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION);
        if (configurationElements.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            String xmiResource = configuration.getAttribute("xmi");
            URI resourceURI = URI.createURI((String)("platform:/plugin/" + configuration.getContributor().getName() + "/" + xmiResource));
            VTViewTemplate viewTemplate = ViewTemplateSupplierUtil.loadViewTemplate(resourceURI);
            if (viewTemplate != null) {
                if (RuntimeModeUtil.isSegmentMode()) {
                    this.generateSegments(viewTemplate);
                }
                this.registeredTemplates.add(viewTemplate);
            } else {
                this.reportService.report(new AbstractReport(MessageFormat.format("The registered resource at location \"{0}\" did not contain a valid VTViewTemplate.", resourceURI.toPlatformString(true)), 2));
            }
            ++n2;
        }
    }

    protected void generateSegments(VTViewTemplate template) {
        List dmrSelectors = template.getStyles().stream().map(VTStyleSelectorContainer::getSelector).filter(VTDomainModelReferenceSelector.class::isInstance).map(VTDomainModelReferenceSelector.class::cast).collect(Collectors.toList());
        for (VTDomainModelReferenceSelector dmrSelector : dmrSelectors) {
            List segments;
            VDomainModelReference dmr = dmrSelector.getDomainModelReference();
            if (!(dmr instanceof VFeaturePathDomainModelReference) || !dmr.getSegments().isEmpty() || (segments = this.segmentGenerator.generateSegments(dmr)).isEmpty()) continue;
            dmr.getSegments().addAll((Collection)segments);
            VFeaturePathDomainModelReference featureDmr = (VFeaturePathDomainModelReference)dmr;
            EClass rootEClass = featureDmr.getDomainModelEReferencePath().isEmpty() ? featureDmr.getDomainModelEFeature().getEContainingClass() : ((EReference)featureDmr.getDomainModelEReferencePath().get(0)).getEContainingClass();
            dmrSelector.setRootEClass(rootEClass);
        }
    }

    @Override
    public Set<VTViewTemplate> getViewTemplates() {
        LinkedHashSet<VTViewTemplate> result = new LinkedHashSet<VTViewTemplate>();
        for (VTViewTemplate viewTemplate : this.registeredTemplates) {
            result.add((VTViewTemplate)EcoreUtil.copy((EObject)viewTemplate));
        }
        return result;
    }

    void setViewTemplates(Set<VTViewTemplate> viewTemplates) {
        this.registeredTemplates = viewTemplates;
    }

    @Override
    public Map<VTStyleProperty, Double> getStyleProperties(VElement vElement, ViewModelContext viewModelContext) {
        if (this.registeredTemplates.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<VTStyleProperty, Double> properties = new LinkedHashMap<VTStyleProperty, Double>();
        for (VTViewTemplate viewTemplate : this.registeredTemplates) {
            for (VTStyle style : viewTemplate.getStyles()) {
                double specificity = style.getSelector().isApplicable(vElement, viewModelContext);
                if (VTStyleSelector.NOT_APPLICABLE == specificity) continue;
                for (VTStyleProperty styleProperty : style.getProperties()) {
                    if (properties.containsKey(styleProperty) && (Double)properties.get(styleProperty) > specificity) continue;
                    properties.put(styleProperty, specificity);
                }
            }
        }
        return properties;
    }
}

