/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.editor;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecp.common.spi.ChildrenDescriptorCollector;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.internal.editor.Activator;
import org.eclipse.emfforms.internal.editor.toolbaractions.LoadEcoreAction;
import org.eclipse.emfforms.internal.editor.ui.EditorToolBar;
import org.eclipse.emfforms.internal.swt.treemasterdetail.defaultprovider.DefaultDeleteActionBuilder;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.editor.IEditingDomainAware;
import org.eclipse.emfforms.spi.editor.IToolbarAction;
import org.eclipse.emfforms.spi.editor.helpers.ResourceSetHelpers;
import org.eclipse.emfforms.spi.editor.messages.Messages;
import org.eclipse.emfforms.spi.swt.treemasterdetail.DeleteActionBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.LabelDecoratorProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.MenuProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailMenuListener;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailSWTFactory;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeViewerBuilder;
import org.eclipse.emfforms.spi.swt.treemasterdetail.actions.ActionCollector;
import org.eclipse.emfforms.spi.swt.treemasterdetail.decorator.validation.ecp.ECPValidationLabelDecoratorProvider;
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.RootObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;

public class GenericEditor
extends EditorPart
implements IEditingDomainProvider,
IGotoMarker {
    private static final String GENERIC_EDITOR_CONTEXT = "org.eclipse.emfforms.editor.context";
    private static final String FRAGMENT_URI = "FRAGMENT_URI";
    private static final String RESOURCE_URI = "RESOURCE_URI";
    private static final String ITOOLBAR_ACTIONS_ID = "org.eclipse.emfforms.editor.toolbarActions";
    private ResourceSet resourceSet;
    private final BasicCommandStack commandStack = new BasicCommandStack();
    private TreeMasterDetailComposite rootView;
    private boolean filesChangedWithConflict;
    private final IPartListener partListener = new GenericEditorActivationListener();
    private final IResourceChangeListener resourceChangeListener = new GenericEditorResourceChangeListener();
    private final MarkerHelper markerHelper = new GenericEditorMarkerHelper();
    private final List<Job> markerJobs = new CopyOnWriteArrayList<Job>();
    private DiagnosticCache cache;
    private boolean reloading;
    private boolean closing;

    protected DiagnosticCache getDiagnosticCache() {
        return this.cache;
    }

    public void doSave(IProgressMonitor monitor) {
        this.preSave();
        if (ResourceSetHelpers.save(this.resourceSet, this.getResourceSaveOptions())) {
            this.getCommandStack().saveIsDone();
            this.firePropertyChange(257);
            this.filesChangedWithConflict = false;
        }
        this.postSave();
    }

    protected void preSave() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
    }

    protected void postSave() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    protected void handleResourceChange(final Collection<Resource> changedResources, final Collection<Resource> removedResources) {
        if (!this.isDirty()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GenericEditor.this.resourceSet == null || GenericEditor.this.rootView.isDisposed()) {
                        return;
                    }
                    GenericEditor.this.reloading = true;
                    GenericEditor.this.removeResources(removedResources);
                    for (Resource changed : changedResources) {
                        Resource toReload = GenericEditor.this.resourceSet.getResource(changed.getURI(), false);
                        if (toReload == null) continue;
                        toReload.unload();
                        try {
                            toReload.load(null);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    GenericEditor.this.rootView.getSelectionProvider().refresh();
                    GenericEditor.this.reloading = false;
                    GenericEditor.this.getCommandStack().flush();
                    GenericEditor.this.initMarkers();
                }
            });
        } else {
            this.filesChangedWithConflict = true;
        }
    }

    private boolean discardChanges() {
        return MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.GenericEditor_DiscardChangesTitle, (String)Messages.GenericEditor_DiscardChangesDescription);
    }

    public void doSaveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        int result = saveAsDialog.open();
        if (result == 0) {
            IPath path = saveAsDialog.getResult();
            this.setPartName(path.lastSegment());
            ((Resource)this.resourceSet.getResources().get(0)).setURI(URI.createFileURI((String)path.toOSString()));
            this.doSave(null);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                GenericEditor.this.firePropertyChange(257);
            }
        });
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        this.resourceSet = this.loadResource(this.getEditorInput());
    }

    protected String getContextId() {
        return GENERIC_EDITOR_CONTEXT;
    }

    public boolean isDirty() {
        return this.getCommandStack().isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        parent.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        parent.setBackgroundMode(2);
        Object editorInput = this.modifyEditorInput(this.resourceSet);
        if (this.enableValidation()) {
            this.setupDiagnosticCache(editorInput);
            this.getDiagnosticCache().registerValidationListener((DiagnosticCache.ValidationListener)new MarkerValidationListener());
        }
        this.rootView = this.createRootView(parent, this.getEditorTitle(), editorInput, this.getToolbarActions(), this.getCreateElementCallback());
        this.initMarkers();
        this.getEditorSite().setSelectionProvider(this.rootView.getMasterDetailSelectionProvider());
    }

    private synchronized void initMarkers() {
        if (this.getDiagnosticCache() == null || this.reloading) {
            return;
        }
        if (this.markerJobs.size() > 1) {
            return;
        }
        Job job = Job.create((String)Messages.GenericEditor_ValidationMarkersJobName, (IJobFunction)new IJobFunction(){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    GenericEditor.this.adjustMarkers(monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (CoreException ex) {
                    Status status = new Status(4, "org.eclipse.emfforms.editor", ex.getMessage(), (Throwable)ex);
                    return status;
                }
                finally {
                    GenericEditor.this.markerJobs.remove(0);
                }
            }
        });
        job.setPriority(20);
        this.markerJobs.add(job);
        job.schedule();
    }

    private synchronized void adjustMarkers(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || this.reloading) {
            return;
        }
        this.deleteMarkers();
        for (Object o : this.getDiagnosticCache().getObjects()) {
            try {
                if (monitor.isCanceled() || this.reloading) {
                    return;
                }
                Diagnostic value = this.getDiagnosticCache().getOwnValue(o);
                if (value.getSeverity() < 2) continue;
                this.markerHelper.createMarkers(value);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    protected void deleteMarkers() throws CoreException {
        Optional<IFile> file = this.getFile();
        if (!file.isPresent()) {
            return;
        }
        ((IFile)file.get()).deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
    }

    protected Notifier getNotifierFromEditorInput(Object editorInput) {
        Object input = editorInput;
        if (input instanceof RootObject) {
            input = ((RootObject)input).getRoot();
        }
        if (!Notifier.class.isInstance(input)) {
            throw new IllegalStateException("The editor input is not a Notifier!");
        }
        return (Notifier)input;
    }

    private void setupDiagnosticCache(Object editorInput) {
        this.cache = this.createDiangosticCache(this.getNotifierFromEditorInput(editorInput));
    }

    protected DiagnosticCache createDiangosticCache(Notifier input) {
        return new DiagnosticCache(input);
    }

    protected boolean enableValidation() {
        return false;
    }

    protected TreeMasterDetailComposite createRootView(Composite parent, String editorTitle, Object editorInput, List<Action> toolbarActions, CreateElementCallback createElementCallback) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        FormData toolbarLayoutData = new FormData();
        toolbarLayoutData.left = new FormAttachment(0);
        toolbarLayoutData.right = new FormAttachment(100);
        toolbarLayoutData.top = new FormAttachment(0);
        EditorToolBar toolbar = new EditorToolBar(composite, 0, editorTitle, toolbarActions);
        toolbar.setLayoutData(toolbarLayoutData);
        FormData treeMasterDetailLayoutData = new FormData();
        treeMasterDetailLayoutData.top = new FormAttachment((Control)toolbar, 5);
        treeMasterDetailLayoutData.left = new FormAttachment(0);
        treeMasterDetailLayoutData.right = new FormAttachment(100);
        treeMasterDetailLayoutData.bottom = new FormAttachment(100);
        TreeMasterDetailComposite treeMasterDetail = this.createTreeMasterDetail(composite, editorInput, createElementCallback);
        treeMasterDetail.setLayoutData((Object)treeMasterDetailLayoutData);
        for (Action action : toolbarActions) {
            if (!(action instanceof IEditingDomainAware)) continue;
            ((IEditingDomainAware)action).setEditingDomain(this.getEditingDomain());
        }
        return treeMasterDetail;
    }

    protected TreeMasterDetailComposite getRootView() {
        return this.rootView;
    }

    protected TreeMasterDetailComposite createTreeMasterDetail(Composite composite, Object editorInput, final CreateElementCallback createElementCallback) {
        TreeMasterDetailSWTBuilder builder = TreeMasterDetailSWTFactory.fillDefaults((Composite)composite, (int)0, (Object)editorInput).customizeCildCreation(createElementCallback).customizeMenu(new MenuProvider(){

            public Menu getMenu(TreeViewer treeViewer, EditingDomain editingDomain) {
                MenuManager menuMgr = new MenuManager();
                menuMgr.setRemoveAllWhenShown(true);
                List masterDetailActions = ActionCollector.newList().addCutAction(editingDomain).addCopyAction(editingDomain).addPasteAction(editingDomain).getList();
                menuMgr.addMenuListener((IMenuListener)new TreeMasterDetailMenuListener(new ChildrenDescriptorCollector(), menuMgr, treeViewer, editingDomain, (Collection)masterDetailActions, createElementCallback, (DeleteActionBuilder)new DefaultDeleteActionBuilder()));
                Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
                return menu;
            }
        }).customizeTree(this.createTreeViewerBuilder());
        if (this.enableValidation()) {
            builder.customizeLabelDecorator((LabelDecoratorProvider)new ECPValidationLabelDecoratorProvider(this.getNotifierFromEditorInput(editorInput), this.getDiagnosticCache()));
        }
        TreeMasterDetailComposite treeMasterDetail = builder.create();
        return treeMasterDetail;
    }

    protected TreeViewerBuilder createTreeViewerBuilder() {
        return parent -> {
            TreeViewer treeViewer = new TreeViewer(parent, 2050);
            treeViewer.setAutoExpandLevel(3);
            treeViewer.getTree().addFocusListener(new FocusListener(){
                private IContextActivation activation;

                public void focusLost(FocusEvent e) {
                    ((IContextService)GenericEditor.this.getSite().getService(IContextService.class)).deactivateContext(this.activation);
                }

                public void focusGained(FocusEvent e) {
                    this.activation = ((IContextService)GenericEditor.this.getSite().getService(IContextService.class)).activateContext(GenericEditor.this.getContextId());
                }
            });
            return treeViewer;
        };
    }

    protected Object modifyEditorInput(ResourceSet resourceSet) {
        return resourceSet;
    }

    protected ResourceSet loadResource(IEditorInput editorInput) throws PartInitException {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)editorInput, null);
        ResourceSet resourceSet = ResourceSetHelpers.createResourceSet((CommandStack)this.getCommandStack());
        try {
            resourceSet = ResourceSetHelpers.loadResourceWithProxies(resourceURI, resourceSet, this.getResourceLoadOptions());
            this.verifyEditorResource(resourceURI, resourceSet);
            return resourceSet;
        }
        catch (Exception e) {
            throw new PartInitException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void verifyEditorResource(URI resourceURI, ResourceSet resourceSet) {
        Resource resource = resourceSet.getResource(resourceURI, true);
        if (XMLResource.class.isInstance(resource) && !((XMLResource)XMLResource.class.cast(resource)).getEObjectToExtensionMap().isEmpty()) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)Messages.GenericEditor_UnknownFeaturesDialogTitle, (String)Messages.GenericEditor_UnknownFeaturesDialogDescription);
        }
    }

    protected Map<Object, Object> getResourceLoadOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        options.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        return options;
    }

    protected Map<Object, Object> getResourceSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        saveOptions.put("ENCODING", "UTF-8");
        return saveOptions;
    }

    public void setFocus() {
    }

    protected boolean hasShortcuts() {
        return false;
    }

    protected String getEditorTitle() {
        return Messages.GenericEditor_EditorTitle;
    }

    protected CreateElementCallback getCreateElementCallback() {
        return null;
    }

    public EditingDomain getEditingDomain() {
        if (this.rootView == null) {
            return null;
        }
        return this.rootView.getEditingDomain();
    }

    protected List<Action> getToolbarActions() {
        LinkedList<Action> result = new LinkedList<Action>();
        result.add(new LoadEcoreAction(this.resourceSet));
        result.addAll(this.readToolbarActions());
        return result;
    }

    protected List<Action> readToolbarActions() {
        IConfigurationElement[] config;
        LinkedList<Action> result = new LinkedList<Action>();
        GenericEditorSelectionProvider selectionProvider = new GenericEditorSelectionProvider();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return result;
        }
        IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(ITOOLBAR_ACTIONS_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                IToolbarAction action;
                Object o = e.createExecutableExtension("toolbarAction");
                if (o instanceof IToolbarAction && (action = (IToolbarAction)o).canExecute(this.resourceSet)) {
                    result.add(action.getAction(this.resourceSet, selectionProvider));
                }
            }
            catch (CoreException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.internal.editor", ex.getMessage(), (Throwable)ex)));
            }
            ++n2;
        }
        return result;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void dispose() {
        if (this.getDiagnosticCache() != null) {
            this.getDiagnosticCache().dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }

    private Optional<IFile> getFile() {
        IEditorInput input = this.getEditorInput();
        if (IFileEditorInput.class.isInstance(input)) {
            return Optional.of((Object)((IFileEditorInput)IFileEditorInput.class.cast(input)).getFile());
        }
        return Optional.empty();
    }

    public void gotoMarker(IMarker marker) {
        try {
            String resourceURI = (String)marker.getAttribute(RESOURCE_URI);
            String fragmentURI = (String)marker.getAttribute(FRAGMENT_URI);
            if (resourceURI == null || fragmentURI == null) {
                return;
            }
            Resource resource = this.getEditingDomain().getResourceSet().getResource(URI.createURI((String)resourceURI), true);
            EObject eObject = resource.getEObject(fragmentURI);
            if (eObject == null) {
                return;
            }
            this.reveal(eObject);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void reveal(EObject objectToReveal) {
        this.rootView.getSelectionProvider().refresh();
        while (objectToReveal != null) {
            this.rootView.getSelectionProvider().reveal((Object)objectToReveal);
            if (this.rootView.getSelectionProvider().testFindItem((Object)objectToReveal) != null) break;
            objectToReveal = objectToReveal.eContainer();
        }
        if (objectToReveal == null) {
            return;
        }
        this.rootView.setSelection((ISelection)new StructuredSelection((Object)objectToReveal));
    }

    protected BasicCommandStack getCommandStack() {
        return this.commandStack;
    }

    protected boolean adjustErrorMarker(IMarker marker, Diagnostic diagnostic) throws CoreException {
        List data = diagnostic.getData();
        if (data.size() < 1) {
            return false;
        }
        if (!EObject.class.isInstance(data.get(0))) {
            return false;
        }
        EObject eObject = (EObject)EObject.class.cast(data.get(0));
        if (eObject.eResource() == null) {
            return false;
        }
        String uri = eObject.eResource().getURI().toString();
        String uriFragment = eObject.eResource().getURIFragment(eObject);
        marker.setAttribute(RESOURCE_URI, (Object)uri);
        marker.setAttribute(FRAGMENT_URI, (Object)uriFragment);
        return true;
    }

    protected boolean isClosing() {
        return this.closing;
    }

    protected void setClosing(boolean closing) {
        this.closing = closing;
    }

    protected void removeResources(Collection<Resource> resources) {
        for (Resource removed : resources) {
            Resource toRemove = this.resourceSet.getResource(removed.getURI(), false);
            if (toRemove == null) continue;
            this.resourceSet.getResources().remove((Object)toRemove);
        }
    }

    private final class GenericEditorActivationListener
    implements IPartListener {
        private GenericEditorActivationListener() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            if (!GenericEditor.this.isClosing() && part == GenericEditor.this && GenericEditor.this.isDirty() && GenericEditor.this.filesChangedWithConflict && GenericEditor.this.discardChanges()) {
                GenericEditor.this.reloading = true;
                for (Resource r : GenericEditor.this.resourceSet.getResources()) {
                    r.unload();
                    try {
                        r.load(null);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                GenericEditor.this.rootView.getSelectionProvider().refresh();
                GenericEditor.this.reloading = false;
                GenericEditor.this.getCommandStack().flush();
                GenericEditor.this.initMarkers();
                GenericEditor.this.firePropertyChange(257);
                GenericEditor.this.filesChangedWithConflict = false;
            }
        }
    }

    private final class GenericEditorMarkerHelper
    extends EditUIMarkerHelper {
        private GenericEditorMarkerHelper() {
        }

        public IFile getFile(Diagnostic diagnostic) {
            Optional file = GenericEditor.this.getFile();
            if (file.isPresent()) {
                return (IFile)file.get();
            }
            return super.getFile(diagnostic);
        }

        protected boolean adjustMarker(IMarker marker, Diagnostic diagnostic) throws CoreException {
            return GenericEditor.this.adjustErrorMarker(marker, diagnostic);
        }
    }

    private final class GenericEditorResourceChangeListener
    implements IResourceChangeListener {
        private GenericEditorResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            ArrayList<Resource> changedResources = new ArrayList<Resource>();
            ArrayList<Resource> removedResources = new ArrayList<Resource>();
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept((IResourceDeltaVisitor)new GenericEditorResourceDeltaVisitor(removedResources, changedResources));
            }
            catch (CoreException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.internal.editor", ex.getMessage(), (Throwable)ex)));
            }
            if (changedResources.isEmpty() && removedResources.isEmpty()) {
                return;
            }
            GenericEditor.this.handleResourceChange(changedResources, removedResources);
        }
    }

    private final class GenericEditorResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final Collection<Resource> removedResources;
        private final Collection<Resource> changedResources;

        GenericEditorResourceDeltaVisitor(Collection<Resource> removedResources, Collection<Resource> changedResources) {
            this.removedResources = removedResources;
            this.changedResources = changedResources;
        }

        public boolean visit(IResourceDelta delta) {
            if ((delta.getFlags() & 0x20000) != 0) {
                return false;
            }
            if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4)) {
                ResourceSet resourceSet = GenericEditor.this.getResourceSet();
                if (resourceSet == null) {
                    return false;
                }
                Resource resource = null;
                URI uri = URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true);
                resource = resourceSet.getResource(uri, false);
                if (resource == null) {
                    try {
                        URL fileURL = FileLocator.resolve((URL)new URL(uri.toString()));
                        resource = resourceSet.getResource(URI.createFileURI((String)fileURL.getPath()), false);
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
                if (resource != null) {
                    if (delta.getKind() == 2) {
                        this.removedResources.add(resource);
                    } else {
                        this.changedResources.add(resource);
                    }
                }
                return false;
            }
            return true;
        }
    }

    private class GenericEditorSelectionProvider
    implements ISelectionProvider {
        private GenericEditorSelectionProvider() {
        }

        public void setSelection(ISelection selection) {
            if (GenericEditor.this.rootView == null) {
                return;
            }
            GenericEditor.this.rootView.getSelectionProvider().setSelection(selection);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (GenericEditor.this.rootView == null) {
                return;
            }
            GenericEditor.this.rootView.getSelectionProvider().removeSelectionChangedListener(listener);
        }

        public ISelection getSelection() {
            if (GenericEditor.this.rootView == null) {
                return StructuredSelection.EMPTY;
            }
            return GenericEditor.this.rootView.getSelectionProvider().getSelection();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (GenericEditor.this.rootView == null) {
                return;
            }
            GenericEditor.this.rootView.getSelectionProvider().addSelectionChangedListener(listener);
        }
    }

    private final class MarkerValidationListener
    implements DiagnosticCache.ValidationListener {
        private MarkerValidationListener() {
        }

        public void revalidationOccurred(Collection<EObject> object, boolean potentialStructuralChange) {
            GenericEditor.this.initMarkers();
        }
    }
}

