/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.treemasterdetail.ui.swt.MasterDetailAction;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.ide.view.segments.ToolingModeUtil;
import org.eclipse.emfforms.view.spi.multisegment.model.MultiSegmentUtil;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultisegmentPackage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateTableColumnSegmentDmrsHandler
extends MasterDetailAction {
    private final ReportService reportService;
    private final EMFFormsDatabindingEMF databinding;

    public GenerateTableColumnSegmentDmrsHandler() {
        this(Activator.getDefault().getEMFFormsDatabinding(), Activator.getDefault().getReportService());
    }

    GenerateTableColumnSegmentDmrsHandler(EMFFormsDatabindingEMF databinding, ReportService reportService) {
        this.databinding = databinding;
        this.reportService = reportService;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null || !(selection instanceof EObject)) {
            return null;
        }
        this.execute((EObject)selection);
        return null;
    }

    public boolean shouldShow(EObject eObject) {
        return VTableControl.class.isInstance(eObject) && ToolingModeUtil.isSegmentToolingEnabled();
    }

    public void execute(EObject object) {
        IEMFValueProperty tableProperty;
        VTableControl tableControl = (VTableControl)object;
        EClass viewRootEClass = Helper.getRootEClass((EObject)tableControl);
        if (viewRootEClass == null) {
            this.reportService.report(new AbstractReport("Could not generate column dmrs because the view's root EClass could not be determined."));
            return;
        }
        VDomainModelReference multiDmr = tableControl.getDomainModelReference();
        if (multiDmr == null) {
            this.reportService.report(new AbstractReport("Could not generate column dmrs because the table control's dmr is null."));
            return;
        }
        Optional multiSegment = MultiSegmentUtil.getMultiSegment((VDomainModelReference)multiDmr);
        if (!multiSegment.isPresent()) {
            this.reportService.report(new AbstractReport("Could not generate column dmrs because the table control's dmr doesn't end in a multi segment"));
            return;
        }
        try {
            tableProperty = this.databinding.getValueProperty(multiDmr, viewRootEClass);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex, "Could not generate column dmrs."));
            return;
        }
        EStructuralFeature tableFeature = tableProperty.getStructuralFeature();
        if (!(tableFeature instanceof EReference)) {
            this.reportService.report(new AbstractReport("Could not generate column dmrs because the table control's dmr doesn't end in an EReference."));
            return;
        }
        EReference tableReference = (EReference)tableFeature;
        Optional<EClass> columnRoot = this.getColumnDmrRootEClass(tableReference.getEReferenceType());
        if (!columnRoot.isPresent()) {
            return;
        }
        LinkedHashSet<EStructuralFeature> existingChildDmrFeatures = new LinkedHashSet<EStructuralFeature>();
        for (VDomainModelReference ref : ((VMultiDomainModelReferenceSegment)multiSegment.get()).getChildDomainModelReferences()) {
            IEMFValueProperty property;
            try {
                property = this.databinding.getValueProperty(ref, columnRoot.get());
            }
            catch (DatabindingFailedException ex) {
                this.reportService.report(new AbstractReport((Throwable)ex));
                continue;
            }
            existingChildDmrFeatures.add(property.getStructuralFeature());
        }
        LinkedHashSet generatedChildDmrs = new LinkedHashSet();
        columnRoot.get().getEAllAttributes().stream().filter(attribute -> !existingChildDmrFeatures.contains(attribute)).map(ENamedElement::getName).map(GenerateTableColumnSegmentDmrsHandler::createFeatureSegment).map(GenerateTableColumnSegmentDmrsHandler::createDmr).forEach(generatedChildDmrs::add);
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)multiSegment.get()));
        Command command = AddCommand.create((EditingDomain)editingDomain, multiSegment.get(), (Object)VMultisegmentPackage.Literals.MULTI_DOMAIN_MODEL_REFERENCE_SEGMENT__CHILD_DOMAIN_MODEL_REFERENCES, generatedChildDmrs);
        editingDomain.getCommandStack().execute(command);
    }

    protected Optional<EClass> getColumnDmrRootEClass(EClass baseEClass) {
        return Optional.of(baseEClass);
    }

    private static VFeatureDomainModelReferenceSegment createFeatureSegment(String featureName) {
        VFeatureDomainModelReferenceSegment segment = VViewFactory.eINSTANCE.createFeatureDomainModelReferenceSegment();
        segment.setDomainModelFeature(featureName);
        return segment;
    }

    private static VDomainModelReference createDmr(VDomainModelReferenceSegment segment) {
        VDomainModelReference dmr = VViewFactory.eINSTANCE.createDomainModelReference();
        dmr.getSegments().add((Object)segment);
        return dmr;
    }
}

