/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.genmodel.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.group.model.VGroup;
import org.eclipse.emf.ecp.view.spi.group.model.VGroupPackage;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;

public class GenModelGroupExpansionViewModelService
implements ViewModelService {
    private static final String ECORE_STANDARD = "Standard";
    private static final String ECORE_ADVANCED = "Advanced";
    private static final String GENMODEL_ALL = "All";
    private static final String GENMODEL_EDIT = "Edit";
    private static final String GENMODEL_EDITOR = "Editor";
    private static final String GENMODEL_MODEL = "Model";
    private static final String GENMODEL_MODEL_CLASS_DEFAULTS = "Model Class Defaults";
    private static final String GENMODEL_MODEL_FEATURE_DEFAULTS = "Model Feature Defaults";
    private static final String GENMODEL_PACKAGE_SUFFIXES = "Package Suffixes";
    private static final String GENMODEL_TEMPLATES_MERGE = "Templates & Merge";
    private static final String GENMODEL_TESTS = "Tests";
    private static final Map<String, Boolean> GROUP_COLLAPSED_STATES = new HashMap<String, Boolean>();
    private ViewModelContext viewModelContext;
    private final ModelChangeListener collapsedStateListener = new ModelChangeListener(){

        public void notifyChange(ModelChangeNotification notification) {
            if (notification.getNotifier() instanceof VGroup && notification.getStructuralFeature().equals(VGroupPackage.Literals.GROUP__COLLAPSED)) {
                VGroup group = (VGroup)notification.getNotifier();
                GROUP_COLLAPSED_STATES.put(group.getName(), group.isCollapsed());
            }
        }
    };

    static {
        GROUP_COLLAPSED_STATES.put(ECORE_STANDARD, Boolean.FALSE);
        GROUP_COLLAPSED_STATES.put(ECORE_ADVANCED, Boolean.FALSE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_ALL, Boolean.FALSE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_EDIT, Boolean.TRUE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_EDITOR, Boolean.TRUE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_MODEL, Boolean.TRUE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_MODEL_CLASS_DEFAULTS, Boolean.TRUE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_MODEL_FEATURE_DEFAULTS, Boolean.TRUE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_PACKAGE_SUFFIXES, Boolean.TRUE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_TEMPLATES_MERGE, Boolean.TRUE);
        GROUP_COLLAPSED_STATES.put(GENMODEL_TESTS, Boolean.TRUE);
    }

    public void instantiate(ViewModelContext context) {
        VElement viewModel = context.getViewModel();
        if (!(viewModel instanceof VView)) {
            return;
        }
        VView view = (VView)viewModel;
        this.viewModelContext = context;
        for (VContainedElement element : view.getChildren()) {
            VGroup group;
            Boolean groupCollapsedState;
            if (!(element instanceof VGroup) || (groupCollapsedState = GROUP_COLLAPSED_STATES.get((group = (VGroup)element).getName())) == null) continue;
            group.setCollapsed(groupCollapsedState.booleanValue());
        }
        context.registerViewChangeListener(this.collapsedStateListener);
    }

    public void dispose() {
        if (this.viewModelContext != null) {
            this.viewModelContext.unregisterViewChangeListener(this.collapsedStateListener);
        }
    }

    public int getPriority() {
        return 0;
    }
}

