/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.edapt.migration.AbstractResource;
import org.eclipse.emf.edapt.migration.AttributeSlot;
import org.eclipse.emf.edapt.migration.DiagnosticException;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.MetamodelResource;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.MigrationPackage;
import org.eclipse.emf.edapt.migration.MigrationPlugin;
import org.eclipse.emf.edapt.migration.Model;
import org.eclipse.emf.edapt.migration.ModelResource;
import org.eclipse.emf.edapt.migration.ReferenceSlot;
import org.eclipse.emf.edapt.migration.Repository;
import org.eclipse.emf.edapt.migration.Slot;
import org.eclipse.emf.edapt.migration.Type;
import org.eclipse.emf.edapt.migration.impl.SlotImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationValidator
extends EObjectValidator {
    public static final MigrationValidator INSTANCE = new MigrationValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.edapt.migration";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return MigrationPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateRepository((Repository)value, diagnostics, context);
            }
            case 1: {
                return this.validateModel((Model)value, diagnostics, context);
            }
            case 2: {
                return this.validateModelResource((ModelResource)value, diagnostics, context);
            }
            case 3: {
                return this.validateType((Type)value, diagnostics, context);
            }
            case 4: {
                return this.validateInstance((Instance)value, diagnostics, context);
            }
            case 5: {
                return this.validateSlot((Slot)value, diagnostics, context);
            }
            case 6: {
                return this.validateAttributeSlot((AttributeSlot)value, diagnostics, context);
            }
            case 7: {
                return this.validateReferenceSlot((ReferenceSlot)value, diagnostics, context);
            }
            case 8: {
                return this.validateMetamodel((Metamodel)value, diagnostics, context);
            }
            case 9: {
                return this.validateMetamodelResource((MetamodelResource)value, diagnostics, context);
            }
            case 10: {
                return this.validateAbstractResource((AbstractResource)value, diagnostics, context);
            }
            case 11: {
                return this.validateSet((Set)value, diagnostics, context);
            }
            case 12: {
                return this.validateDiagnosticChain((DiagnosticChain)value, diagnostics, context);
            }
            case 13: {
                return this.validateURI((URI)value, diagnostics, context);
            }
            case 14: {
                return this.validateDiagnosticException((DiagnosticException)value, diagnostics, context);
            }
            case 15: {
                return this.validateMigrationException((MigrationException)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateModel(Model model, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)model, diagnostics, context);
    }

    public boolean validateMetamodel(Metamodel metamodel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)metamodel, diagnostics, context);
    }

    public boolean validateType(Type type, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)type, diagnostics, context);
    }

    public boolean validateInstance(Instance instance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)instance, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)instance, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)instance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)instance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)instance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)instance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)instance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)instance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)instance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInstance_validContainment(instance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateInstance_validType(instance, diagnostics, context);
        }
        return result;
    }

    public boolean validateInstance_validContainment(Instance instance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_validContainment(instance)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{"validContainment", MigrationValidator.getObjectLabel((EObject)((EObject)instance), context)}), new Object[]{instance}));
            }
            return false;
        }
        return true;
    }

    private boolean validate_validContainment(Instance instance) {
        if (instance.isProxy()) {
            return true;
        }
        int container = 0;
        for (ReferenceSlot referenceSlot : instance.getReferences()) {
            if (!referenceSlot.getEReference().isContainment()) continue;
            ++container;
        }
        int resources = 0;
        Model model = instance.getType().getModel();
        for (ModelResource modelResource : model.getResources()) {
            if (!modelResource.getRootInstances().contains((Object)instance)) continue;
            ++resources;
        }
        boolean valid = container == 1 && resources <= 1 || resources == 1 && container <= 1;
        return valid;
    }

    public boolean validateInstance_validType(Instance instance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_validType(instance)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{"validType", MigrationValidator.getObjectLabel((EObject)((EObject)instance), context)}), new Object[]{instance}));
            }
            return false;
        }
        return true;
    }

    private boolean validate_validType(Instance instance) {
        EClass eClass = instance.getEClass();
        boolean result = eClass != null && eClass.getEPackage() != null && !eClass.isAbstract();
        return result;
    }

    public boolean validateSlot(Slot slot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)slot, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)slot, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)slot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)slot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)slot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)slot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)slot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)slot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)slot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSlot_validFeature(slot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSlot_validMultiplicity(slot, diagnostics, context);
        }
        return result;
    }

    public boolean validateSlot_validFeature(Slot slot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_validFeature(slot)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{"validFeature", MigrationValidator.getObjectLabel((EObject)((EObject)slot), context)}), new Object[]{slot}));
            }
            return false;
        }
        return true;
    }

    private boolean validate_validFeature(Slot slot) {
        EClass contextClass = slot.getInstance().getEClass();
        EList allowedFeatures = contextClass.getEAllStructuralFeatures();
        boolean isAllowed = allowedFeatures.contains((Object)slot.getEFeature());
        return isAllowed;
    }

    public boolean validateSlot_validMultiplicity(Slot slot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_validMultiplicity(slot)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{"validMultiplicity", MigrationValidator.getObjectLabel((EObject)((EObject)slot), context)}), new Object[]{slot}));
            }
            return false;
        }
        return true;
    }

    private boolean validate_validMultiplicity(Slot slot) {
        int n = ((SlotImpl)slot).getValues().size();
        EStructuralFeature feature = slot.getEFeature();
        return feature.isMany() || n <= 1;
    }

    public boolean validateAttributeSlot(AttributeSlot attributeSlot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)attributeSlot, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)attributeSlot, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)attributeSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)attributeSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)attributeSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)attributeSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)attributeSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)attributeSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)attributeSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSlot_validFeature(attributeSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSlot_validMultiplicity(attributeSlot, diagnostics, context);
        }
        return result;
    }

    public boolean validateReferenceSlot(ReferenceSlot referenceSlot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)referenceSlot, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)referenceSlot, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSlot_validFeature(referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSlot_validMultiplicity(referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateReferenceSlot_validType(referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateReferenceSlot_noDanglingReference(referenceSlot, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateReferenceSlot_validOpposite(referenceSlot, diagnostics, context);
        }
        return result;
    }

    public boolean validateReferenceSlot_validType(ReferenceSlot referenceSlot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_validType(referenceSlot)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{"validType", MigrationValidator.getObjectLabel((EObject)((EObject)referenceSlot), context)}), new Object[]{referenceSlot}));
            }
            return false;
        }
        return true;
    }

    private boolean validate_validType(ReferenceSlot referenceSlot) {
        EClass referenceType = referenceSlot.getEReference().getEReferenceType();
        for (Instance instance : referenceSlot.getValues()) {
            boolean validType;
            EClass instanceType = instance.getEClass();
            boolean bl = validType = instanceType == referenceType || instanceType.getEAllSuperTypes().contains((Object)referenceType) || referenceType == EcorePackage.eINSTANCE.getEObject();
            if (validType) continue;
            return false;
        }
        return true;
    }

    public boolean validateReferenceSlot_noDanglingReference(ReferenceSlot referenceSlot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_noDanglingReference(referenceSlot)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{"noDanglingReference", MigrationValidator.getObjectLabel((EObject)((EObject)referenceSlot), context)}), new Object[]{referenceSlot}));
            }
            return false;
        }
        return true;
    }

    private boolean validate_noDanglingReference(ReferenceSlot referenceSlot) {
        for (Instance instance : referenceSlot.getValues()) {
            if (instance.getType() != null && instance.getType().getModel() != null) continue;
            return false;
        }
        return true;
    }

    public boolean validateReferenceSlot_validOpposite(ReferenceSlot referenceSlot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_validOpposite(referenceSlot)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{"validOpposite", MigrationValidator.getObjectLabel((EObject)((EObject)referenceSlot), context)}), new Object[]{referenceSlot}));
            }
            return false;
        }
        return true;
    }

    private boolean validate_validOpposite(ReferenceSlot referenceSlot) {
        Instance from = referenceSlot.getInstance();
        EReference reference = referenceSlot.getEReference();
        EReference opposite = reference.getEOpposite();
        if (opposite != null) {
            for (Instance to : referenceSlot.getValues()) {
                Object value = to.get((EStructuralFeature)opposite);
                if (!(opposite.isMany() ? !((Collection)value).contains(from) : value != from)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateRepository(Repository repository, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)repository, diagnostics, context);
    }

    public boolean validateModelResource(ModelResource modelResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)modelResource, diagnostics, context);
    }

    public boolean validateAbstractResource(AbstractResource abstractResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)abstractResource, diagnostics, context);
    }

    public boolean validateMetamodelResource(MetamodelResource metamodelResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)metamodelResource, diagnostics, context);
    }

    public boolean validateSet(Set<?> set, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDiagnosticChain(DiagnosticChain diagnosticChain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateURI(URI uri, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateDiagnosticException(DiagnosticException diagnosticException, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateMigrationException(MigrationException migrationException, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return MigrationPlugin.INSTANCE;
    }
}

