/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.internal.common.ResourceUtils;
import org.eclipse.emf.edapt.spi.migration.Metamodel;

public final class BackupUtils {
    public static final String BACKUP_FILE_EXTENSION = "backup";
    public static final String LOG_FILE_EXTENSION = "log";

    private BackupUtils() {
    }

    public static URI getBackupURI(URI modelURI) {
        return modelURI.appendFileExtension(BACKUP_FILE_EXTENSION);
    }

    public static URI getModelURI(URI backupURI) {
        if (BACKUP_FILE_EXTENSION.equals(backupURI.fileExtension())) {
            return backupURI.trimFileExtension();
        }
        return null;
    }

    public static URI getLogURI(URI modelURI) {
        return modelURI.appendFileExtension(LOG_FILE_EXTENSION);
    }

    public static List<URI> backup(List<URI> modelURIs, Metamodel metamodel) throws IOException {
        return BackupUtils.copy(modelURIs, metamodel, new BackupMapper());
    }

    public static List<URI> restore(List<URI> backupURIs, Metamodel metamodel) throws IOException {
        return BackupUtils.copy(backupURIs, metamodel, new RestoreMapper());
    }

    public static List<URI> copy(List<URI> sourceURIs, Metamodel metamodel, URIMapper mapper) throws IOException {
        ArrayList<URI> targetURIs = new ArrayList<URI>();
        ResourceSet model = ResourceUtils.loadResourceSet(sourceURIs, metamodel.getEPackages());
        for (Resource resource : model.getResources()) {
            URI targetURI;
            if (resource.getURI() == null || resource.getURI().isPlatformPlugin() || (targetURI = mapper.map(resource.getURI())) == null) continue;
            resource.setURI(targetURI);
            targetURIs.add(targetURI);
        }
        ResourceUtils.saveResourceSet((ResourceSet)model);
        return targetURIs;
    }

    private static class BackupMapper
    implements URIMapper {
        private BackupMapper() {
        }

        @Override
        public URI map(URI uri) {
            return BackupUtils.getBackupURI(uri);
        }
    }

    private static class RestoreMapper
    implements URIMapper {
        private RestoreMapper() {
        }

        @Override
        public URI map(URI uri) {
            return BackupUtils.getModelURI(uri);
        }
    }

    public static interface URIMapper {
        public URI map(URI var1);
    }
}

