/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition;

import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.UnexpectedTypeException;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.ComposedConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.ComposedGenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchAddress;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchAddressListContainer;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchAddressMixDirectAnnotationAndListContainer;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchZipcode;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchZipcodeWithDefaultOverridesAttributeName;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.FrenchZipcodeWithInvalidOverride;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.Friend;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.GenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.GermanAddress;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.GermanZipcode;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.ParametersNotEmpty;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.Severity;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.Shoe;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ConstraintCompositionTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ConstraintCompositionTest.webArchiveBuilder().withTestClassPackage(ConstraintCompositionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="a"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="q")})
    public void testComposedConstraints() {
        FrenchAddress address = this.getFrenchAddressWithoutZipCode();
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withMessage("may not be null").withRootBeanClass(FrenchAddress.class).withInvalidValue(null).withProperty("zipCode"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="a"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="q")})
    public void testComposedConstraintsAreRecursive() {
        GermanAddress address = new GermanAddress();
        address.setAddressline1("Rathausstrasse 5");
        address.setAddressline2("3ter Stock");
        address.setCity("Karlsruhe");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(GermanZipcode.class).withRootBeanClass(GermanAddress.class).withInvalidValue(null).withProperty("zipCode"));
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="b")
    public void testValidationOfMainAnnotationIsAlsoApplied() {
        FrenchAddress address = this.getFrenchAddressWithoutZipCode();
        address.setZipCode("00000");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(FrenchZipcode.class).withMessage("00000 is a reserved code"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="c"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="n"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="r"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="s"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="v")})
    public void testEachFailingConstraintCreatesConstraintViolation() {
        FrenchAddress address = this.getFrenchAddressWithoutZipCode();
        address.setZipCode("abc");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withRootBeanClass(FrenchAddress.class).withProperty("zipCode").withInvalidValue("abc"), ConstraintViolationAssert.violationOf(Pattern.class).withRootBeanClass(FrenchAddress.class).withProperty("zipCode").withInvalidValue("abc"), ConstraintViolationAssert.violationOf(Size.class).withRootBeanClass(FrenchAddress.class).withProperty("zipCode").withInvalidValue("abc"));
        address.setZipCode("123");
        constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withRootBeanClass(FrenchAddress.class).withProperty("zipCode").withInvalidValue("123"), ConstraintViolationAssert.violationOf(Size.class).withRootBeanClass(FrenchAddress.class).withProperty("zipCode").withInvalidValue("123"));
        address.setZipCode("33023");
        constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="t")
    public void testConstraintIndexWithListContainer() {
        FrenchAddressListContainer address = this.getFrenchAddressListContainerWithoutZipCode();
        address.setZipCode("abc");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withRootBeanClass(FrenchAddressListContainer.class).withProperty("zipCode").withInvalidValue("abc"), ConstraintViolationAssert.violationOf(Pattern.class).withRootBeanClass(FrenchAddressListContainer.class).withProperty("zipCode").withInvalidValue("abc"), ConstraintViolationAssert.violationOf(Size.class).withRootBeanClass(FrenchAddressListContainer.class).withProperty("zipCode").withInvalidValue("abc"));
        address.setZipCode("33023");
        constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test(expectedExceptions={ConstraintDeclarationException.class})
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="u")
    public void testConstraintIndexWithMixDirectAnnotationAndListContainer() {
        FrenchAddressMixDirectAnnotationAndListContainer address = this.getFrenchAddressMixDirectAnnotationAndListContainerWithoutZipCode();
        address.setZipCode("abc");
        this.getValidator().validate((Object)address, new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="d"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="e")})
    public void testGroupsDefinedOnMainAnnotationAreInherited() {
        FrenchAddress address = this.getFrenchAddressWithoutZipCode();
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        NotNull notNull = (NotNull)constraintViolation.getConstraintDescriptor().getAnnotation();
        List<Class> groups = Arrays.asList(notNull.groups());
        Assert.assertTrue((groups.size() == 2 ? 1 : 0) != 0, (String)"There should be two groups");
        Assert.assertTrue((boolean)groups.contains(Default.class), (String)"The default group should be in the list.");
        Assert.assertTrue((boolean)groups.contains(FrenchAddress.FullAddressCheck.class), (String)"The FrenchAddress.FullAddressCheck group should be inherited.");
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="l")
    public void testOnlySingleConstraintViolation() {
        GermanAddress address = new GermanAddress();
        address.setAddressline1("Rathausstrasse 5");
        address.setAddressline2("3ter Stock");
        address.setCity("Karlsruhe");
        address.setZipCode("abc");
        Set constraintViolations = this.getValidator().validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(GermanZipcode.class).withRootBeanClass(GermanAddress.class).withProperty("zipCode").withInvalidValue("abc"));
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="m")
    public void testAttributesDefinedOnComposingConstraints() {
        BeanDescriptor descriptor = this.getValidator().getConstraintsForClass(FrenchAddress.class);
        Set constraintDescriptors = descriptor.getConstraintsForProperty("zipCode").getConstraintDescriptors();
        boolean findPattern = this.checkForAppropriateAnnotation(constraintDescriptors);
        Assert.assertTrue((boolean)findPattern, (String)"Could not find @Pattern in composing constraints");
    }

    private boolean checkForAppropriateAnnotation(Set<ConstraintDescriptor<?>> constraintDescriptors) {
        boolean findPattern = false;
        for (ConstraintDescriptor<?> constraintDescriptor : constraintDescriptors) {
            Annotation ann = constraintDescriptor.getAnnotation();
            if (Pattern.class.getName().equals(ann.annotationType().getName())) {
                String regexp = ((Pattern)ann).regexp();
                if (regexp.equals("bar")) {
                    Assert.fail((String)"The regular expression attributes are defined in the composing constraint.");
                }
                findPattern = true;
            }
            findPattern |= this.checkForAppropriateAnnotation(constraintDescriptor.getComposingConstraints());
        }
        return findPattern;
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="p"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="w")})
    public void testOverriddenAttributesMustMatchInType() {
        this.getValidator().validate((Object)new DummyEntityWithZipCode("foobar"), new Class[0]);
    }

    @Test(expectedExceptions={UnexpectedTypeException.class})
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="j")
    public void testAllComposingConstraintsMustBeApplicableToAnnotatedType() {
        this.getValidator().validate((Object)new Shoe(41), new Class[0]);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="f"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="g")})
    public void testPayloadPropagationInComposedConstraints() {
        Friend john = new Friend("John", "Doe");
        Set constraintViolations = this.getValidator().validate((Object)john, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Set payloads = constraintViolation.getConstraintDescriptor().getPayload();
        Assert.assertTrue((payloads.size() == 1 ? 1 : 0) != 0, (String)"There should be one payload in the set");
        Class payload = (Class)payloads.iterator().next();
        Assert.assertTrue((boolean)payload.getName().equals(Severity.Warn.class.getName()), (String)"Unexpected payload");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="h"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="i")})
    public void testConstraintTargetPropagationInComposedConstraints() throws Exception {
        DummyEntityWithGenericAndCrossParameterConstraint object = new DummyEntityWithGenericAndCrossParameterConstraint();
        Method method = DummyEntityWithGenericAndCrossParameterConstraint.class.getMethod("doSomething", Integer.TYPE);
        Object[] parameterValues = new Object[]{0};
        Set constraintViolations = this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(GenericAndCrossParameterConstraint.class));
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
        Assert.assertEquals((Object)constraintViolation.getConstraintDescriptor().getValidationAppliesTo(), (Object)ConstraintTarget.PARAMETERS);
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="k"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="w")})
    public void testMixedConstraintTargetsInComposedAndComposingConstraintsCauseException() throws Exception {
        DummyEntityWithIllegallyComposedConstraint object = new DummyEntityWithIllegallyComposedConstraint();
        Method method = DummyEntityWithIllegallyComposedConstraint.class.getMethod("doSomething", Integer.TYPE);
        Object[] parameterValues = new Object[]{0};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="k"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="w")})
    public void testMixedConstraintTargetsInComposingConstraintsCauseException() throws Exception {
        DummyEntityWithAnotherIllegallyComposedConstraint object = new DummyEntityWithAnotherIllegallyComposedConstraint();
        Method method = DummyEntityWithAnotherIllegallyComposedConstraint.class.getMethod("doSomething", Integer.TYPE);
        Object[] parameterValues = new Object[]{0};
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="o")
    public void testOverridesAttributeWithDefaultName() {
        Set constraintViolations = this.getValidator().validate((Object)DummyEntityWithDefaultAttributeName.valid(), new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        constraintViolations = this.getValidator().validate((Object)DummyEntityWithDefaultAttributeName.invalid(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withProperty("zip").withMessage("Wrong zip code"));
    }

    private FrenchAddress getFrenchAddressWithoutZipCode() {
        FrenchAddress address = new FrenchAddress();
        address.setAddressline1("10 rue des Treuils");
        address.setAddressline2("BP 12 ");
        address.setCity("Bordeaux");
        return address;
    }

    private FrenchAddressListContainer getFrenchAddressListContainerWithoutZipCode() {
        FrenchAddressListContainer address = new FrenchAddressListContainer();
        address.setAddressline1("10 rue des Treuils");
        address.setAddressline2("BP 12 ");
        address.setCity("Bordeaux");
        return address;
    }

    private FrenchAddressMixDirectAnnotationAndListContainer getFrenchAddressMixDirectAnnotationAndListContainerWithoutZipCode() {
        FrenchAddressMixDirectAnnotationAndListContainer address = new FrenchAddressMixDirectAnnotationAndListContainer();
        address.setAddressline1("10 rue des Treuils");
        address.setAddressline2("BP 12 ");
        address.setCity("Bordeaux");
        return address;
    }

    private static class DummyEntityWithDefaultAttributeName {
        @FrenchZipcodeWithDefaultOverridesAttributeName
        private String zip;

        private DummyEntityWithDefaultAttributeName() {
        }

        private static DummyEntityWithDefaultAttributeName valid() {
            DummyEntityWithDefaultAttributeName entity = new DummyEntityWithDefaultAttributeName();
            entity.zip = "69007";
            return entity;
        }

        private static DummyEntityWithDefaultAttributeName invalid() {
            DummyEntityWithDefaultAttributeName entity = new DummyEntityWithDefaultAttributeName();
            entity.zip = "invalid";
            return entity;
        }
    }

    private static class DummyEntityWithAnotherIllegallyComposedConstraint {
        private DummyEntityWithAnotherIllegallyComposedConstraint() {
        }

        @ComposedConstraint
        public void doSomething(int i) {
        }
    }

    private static class DummyEntityWithIllegallyComposedConstraint {
        private DummyEntityWithIllegallyComposedConstraint() {
        }

        @ParametersNotEmpty
        public Object doSomething(int i) {
            return null;
        }
    }

    private static class DummyEntityWithGenericAndCrossParameterConstraint {
        private DummyEntityWithGenericAndCrossParameterConstraint() {
        }

        @ComposedGenericAndCrossParameterConstraint(validationAppliesTo=ConstraintTarget.PARAMETERS)
        public Object doSomething(int i) {
            return null;
        }
    }

    private static class DummyEntityWithZipCode {
        @FrenchZipcodeWithInvalidOverride
        String zip;

        DummyEntityWithZipCode(String zip) {
            this.zip = zip;
        }
    }
}

