/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.containerelementlevel;

import jakarta.validation.Configuration;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.CollectionHelper;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ContainerElementTypeConstraintsForFieldXmlMappingTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ContainerElementTypeConstraintsForFieldXmlMappingTest.webArchiveBuilder().withTestClass(ContainerElementTypeConstraintsForFieldXmlMappingTest.class)).withResource("field-canDeclareContainerElementTypeConstraints-mapping.xml")).withResource("field-canDeclareNestedContainerElementTypeConstraints-mapping.xml")).withResource("field-canDeclareDeeplyNestedContainerElementTypeConstraints-mapping.xml")).withResource("field-canDeclareContainerElementCascades-mapping.xml")).withResource("field-declaringContainerElementTypeConstraintOnNonGenericFieldCausesException-mapping.xml")).withResource("field-declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnFieldCausesException-mapping.xml")).withResource("field-declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnFieldCausesException-mapping.xml")).withResource("field-omittingTypeArgumentForMultiTypeArgumentTypeOnFieldCausesException-mapping.xml")).withResource("field-configuringSameContainerElementTwiceCausesException-mapping.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="d"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareContainerElementTypeConstraintsForFieldWithXmlMapping() {
        Validator validator = this.getValidator("field-canDeclareContainerElementTypeConstraints-mapping.xml");
        Set violations = validator.validate((Object)new FishTank(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 0 and 5"), ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 3 and 10"), ConstraintViolationAssert.violationOf(Size.class).withMessage("size must be between 3 and 10"), ConstraintViolationAssert.violationOf(Min.class).withMessage("must be greater than or equal to 1"), ConstraintViolationAssert.violationOf(Min.class).withMessage("must be greater than or equal to 1"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareNestedContainerElementTypeConstraintsForFieldWithXmlMapping() {
        Validator validator = this.getValidator("field-canDeclareNestedContainerElementTypeConstraints-mapping.xml");
        Set violations = validator.validate((Object)new FishTank(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="f"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="g")})
    public void canDeclareDeeplyNestedContainerElementTypeConstraintsForFieldWithXmlMapping() {
        Validator validator = this.getValidator("field-canDeclareDeeplyNestedContainerElementTypeConstraints-mapping.xml");
        Set violations = validator.validate((Object)new FishTank(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="a"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="b"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="c"), @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="h")})
    public void canDeclareContainerElementCascadesForFieldWithXmlMapping() {
        Validator validator = this.getValidator("field-canDeclareContainerElementCascades-mapping.xml");
        Set violations = validator.validate((Object)new FishTank(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="j")
    public void declaringContainerElementTypeConstraintOnNonGenericFieldCausesException() {
        this.getValidator("field-declaringContainerElementTypeConstraintOnNonGenericFieldCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="k")
    public void declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnFieldCausesException() {
        this.getValidator("field-declaringContainerElementTypeConstraintForNonExistingTypeArgumentIndexOnFieldCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="k")
    public void declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnFieldCausesException() {
        this.getValidator("field-declaringContainerElementTypeConstraintForNonExistingNestedTypeArgumentIndexOnFieldCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="l")
    public void omittingTypeArgumentForMultiTypeArgumentTypeOnFieldCausesException() {
        this.getValidator("field-omittingTypeArgumentForMultiTypeArgumentTypeOnFieldCausesException-mapping.xml");
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml-containerelementconstraints", id="m")
    public void configuringSameContainerElementTwiceCausesException() {
        this.getValidator("field-configuringSameContainerElementTwiceCausesException-mapping.xml");
    }

    private Validator getValidator(String mappingFile) {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.addMapping(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile));
        return config.buildValidatorFactory().getValidator();
    }

    public static class Fish {
        public String name;
    }

    public static class FishTank {
        public Optional<String> model = Optional.of("Too long");
        public Optional<Fish> boss = Optional.of(new Fish());
        public Map<String, Integer> fishCountByType = new HashMap<String, Integer>();
        public Map<String, List<Fish>> fishOfTheMonth;
        public List<Map<String, Set<String>>> tagsOfFishOfTheMonth;
        public int size = 0;

        public FishTank() {
            this.fishCountByType.put("A", -1);
            this.fishCountByType.put("BB", -2);
            this.fishOfTheMonth = new HashMap<String, List<Fish>>();
            List<Fish> january = Arrays.asList(null, new Fish());
            this.fishOfTheMonth.put("january", january);
            Set<String> bobsTags = CollectionHelper.asSet(new String[]{null});
            HashMap<String, Set<String>> januaryTags = new HashMap<String, Set<String>>();
            januaryTags.put("bob", bobsTags);
            this.tagsOfFishOfTheMonth = new ArrayList<Map<String, Set<String>>>();
            this.tagsOfFishOfTheMonth.add(januaryTags);
        }
    }
}

